/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.slave_setup;

import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DelegatingComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.slave_setup.Utils;
import org.kohsuke.stapler.DataBoundConstructor;

public class SetupSlaveLauncher
extends DelegatingComputerLauncher {
    private final String startScript;
    private final String stopScript;

    @DataBoundConstructor
    public SetupSlaveLauncher(ComputerLauncher launcher, String startScript, String stopScript) {
        super(launcher);
        this.startScript = startScript;
        this.stopScript = stopScript;
    }

    private void execute(String script, TaskListener listener) throws IOException, InterruptedException {
        Jenkins jenkins = Jenkins.getInstance();
        if (Strings.isNullOrEmpty((String)script)) {
            listener.getLogger().println("No script to be executed for this on-demand slave.");
            return;
        }
        FilePath root = jenkins.getRootPath();
        int r = Utils.multiOsExecutor(listener, script, root, null);
        if (r != 0) {
            throw new AbortException("Script failed with return code " + Integer.toString(r) + ".");
        }
        listener.getLogger().println("Script executed successfully.");
    }

    public String getStartScript() {
        return this.startScript;
    }

    public String getStopScript() {
        return this.stopScript;
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        this.execute(this.startScript, listener);
        listener.getLogger().println("Pre-Launch HERE Pls Print it " + String.valueOf(computer.isUnix()));
        super.launch(computer, listener);
    }

    public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        super.afterDisconnect(computer, listener);
        try {
            this.execute(this.stopScript, listener);
        }
        catch (Exception e) {
            listener.getLogger().println("Failed executing script '" + this.stopScript + "'.");
            e.printStackTrace(listener.getLogger());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public String getDisplayName() {
            return "Start and stop this node on-demand";
        }
    }
}

