/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.slave_setup;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.slave_setup.Components;
import org.jenkinsci.plugins.slave_setup.SetupConfigItem;
import org.jenkinsci.plugins.slave_setup.Utils;

public class SetupDeployer {
    public static String stringFy(Object obj) {
        return Utils.stringFy(obj);
    }

    public static boolean copyFiles(File localPath, FilePath remotePath) throws IOException, InterruptedException {
        if (localPath != null && StringUtils.isNotBlank((String)localPath.getPath())) {
            Components.info("copying files from " + String.valueOf(localPath));
            int tmp = new FilePath(localPath).copyRecursiveTo(remotePath);
            return tmp == 0;
        }
        return false;
    }

    public static boolean checkLabelsForComputerOrNull(Computer c, SetupConfigItem item) {
        return c == null || item.getAssignedLabelString().equals("") || Utils.labelMatches(item.getAssignedLabelString(), c);
    }

    public static int executeScriptOnSlave(TaskListener listener, String script, FilePath root, EnvVars enviroment) throws IOException, InterruptedException {
        return Utils.multiOsExecutor(listener, script, root, enviroment);
    }

    public static int executeScriptOnMaster(TaskListener listener, String script, EnvVars enviroment) {
        Jenkins node = Jenkins.getInstance();
        FilePath filePath = node.getRootPath();
        Components.debug("Master given path is " + filePath.getRemote());
        try {
            return Utils.multiOsExecutor(listener, script, filePath, enviroment);
        }
        catch (Exception e) {
            Components.info("script failed with exception: " + e.getMessage());
            return -246;
        }
    }

    public static EnvVars createEnvVarsForComputer(Computer c) {
        EnvVars additionalEnvironment = new EnvVars();
        if (c != null) {
            additionalEnvironment.put("NODE_TO_SETUP_NAME", c.getName());
            Node node = c.getNode();
            if (node != null) {
                additionalEnvironment.put("NODE_TO_SETUP_LABELS", Util.join((Collection)node.getAssignedLabels(), (String)" "));
            }
        }
        return additionalEnvironment;
    }
}

