/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.slave_setup;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.labels.LabelAtom;
import hudson.model.labels.LabelExpression;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class SetupConfigItem
extends AbstractDescribableImpl<SetupConfigItem> {
    public static final String DELIMITER = "\u00bc";
    private String prepareScript;
    private File filesDir;
    private String commandLine;
    private boolean deployNow;
    private String assignedLabelString;
    private boolean prepareScriptExecuted = false;

    @DataBoundConstructor
    public SetupConfigItem(String prepareScript, File filesDir, String commandLine, boolean deployNow, String assignedLabelString) {
        this.prepareScript = prepareScript;
        this.filesDir = filesDir;
        this.commandLine = commandLine;
        this.deployNow = deployNow;
        this.assignedLabelString = assignedLabelString;
    }

    public SetupConfigItem() {
    }

    public String getPrepareScript() {
        return this.prepareScript;
    }

    public void setPrepareScript(String prepareScript) {
        this.prepareScript = prepareScript;
    }

    public File getFilesDir() {
        return this.filesDir;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public boolean getDeployNow() {
        return this.deployNow;
    }

    public void setFilesDir(File filesDir) {
        this.filesDir = filesDir.getPath().length() == 0 ? null : filesDir;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = Util.fixEmpty((String)commandLine);
    }

    public void setDeployNow(boolean deployNow) {
        this.deployNow = deployNow;
    }

    public boolean isPrepareScriptExecuted() {
        return this.prepareScriptExecuted;
    }

    public void setPrepareScriptExecuted(boolean prepareScriptExecuted) {
        this.prepareScriptExecuted = prepareScriptExecuted;
    }

    public String getAssignedLabelString() {
        if (StringUtils.isEmpty((String)this.assignedLabelString)) {
            return "";
        }
        try {
            LabelExpression.parseExpression((String)this.assignedLabelString);
            return this.assignedLabelString;
        }
        catch (ANTLRException e) {
            return LabelAtom.escape((String)this.assignedLabelString);
        }
    }

    public void setAssignedLabelString(String assignedLabelString) {
        this.assignedLabelString = assignedLabelString;
    }

    public int hashCode() {
        return (this.prepareScript + String.valueOf(this.filesDir) + this.commandLine).hashCode();
    }

    public String remoteCache() {
        return this.assignedLabelString + DELIMITER + this.hashCode();
    }

    @Extension
    public static class SetupConfigItemDescriptor
    extends Descriptor<SetupConfigItem> {
        public String getDisplayName() {
            return "";
        }
    }
}

