/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.slave_setup;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.Util;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.util.FormValidation;
import hudson.util.LogTaskListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.slave_setup.Components;
import org.jenkinsci.plugins.slave_setup.SetupConfigItem;
import org.jenkinsci.plugins.slave_setup.Utils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class SetupConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(Descriptor.class.getName());
    private List<SetupConfigItem> setupConfigItems = new ArrayList<SetupConfigItem>();

    public SetupConfig() {
        this.load();
    }

    public List<SetupConfigItem> getSetupConfigItems() {
        return this.setupConfigItems;
    }

    public void setSetupConfigItems(List<SetupConfigItem> setupConfigItems) {
        this.setupConfigItems = setupConfigItems;
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.save();
        Components.setLogger((TaskListener)new LogTaskListener(LOGGER, Level.ALL));
        return Components.doConfigSetups(Utils.getAllActiveSlaves());
    }

    public static SetupConfig get() {
        return (SetupConfig)((Object)GlobalConfiguration.all().get(SetupConfig.class));
    }

    public AutoCompletionCandidates doAutoCompleteAssignedLabelString(@QueryParameter String value) {
        AutoCompletionCandidates c = new AutoCompletionCandidates();
        Set labels = Jenkins.getInstance().getLabels();
        List<String> queries = new AutoCompleteSeeder(value).getSeeds();
        for (String term : queries) {
            for (Label l : labels) {
                if (!l.getName().startsWith(term)) continue;
                c.add(l.getName());
            }
        }
        return c;
    }

    public FormValidation doCheckFilesDir(@QueryParameter String value) {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        if (Util.fixEmpty((String)value) == null) {
            return FormValidation.ok();
        }
        if (!new File(value).isDirectory()) {
            return FormValidation.error((String)("Directory " + value + " doesn't exist"));
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckAssignedLabelString(@QueryParameter String value) {
        if (Util.fixEmpty((String)value) == null) {
            return FormValidation.ok();
        }
        try {
            Label.parseExpression((String)value);
        }
        catch (ANTLRException e) {
            return FormValidation.error((Throwable)e, (String)MessageFormat.format("Invalid boolean expression: {0}", value));
        }
        Label l = Jenkins.getInstance().getLabel(value);
        if (l != null && l.isEmpty()) {
            for (LabelAtom a : l.listAtoms()) {
                if (!a.isEmpty()) continue;
                LabelAtom nearest = LabelAtom.findNearest((String)a.getName());
                String guess = MessageFormat.format("No agent/cloud matches this label expression. Did you mean \u2018{1}\u2019 instead of \u2018{0}\u2019?", a.getName(), nearest.getDisplayName());
                return FormValidation.warning((String)guess);
            }
            return FormValidation.warning((String)"No agent/cloud matches this label expression.");
        }
        return FormValidation.ok();
    }

    static class AutoCompleteSeeder {
        private String source;

        AutoCompleteSeeder(String source) {
            this.source = source;
        }

        List<String> getSeeds() {
            ArrayList<String> terms = new ArrayList<String>();
            boolean trailingQuote = this.source.endsWith("\"");
            boolean leadingQuote = this.source.startsWith("\"");
            boolean trailingSpace = this.source.endsWith(" ");
            if (trailingQuote || trailingSpace && !leadingQuote) {
                terms.add("");
            } else if (leadingQuote) {
                int quote = this.source.lastIndexOf(34);
                if (quote == 0) {
                    terms.add(this.source.substring(1));
                } else {
                    terms.add("");
                }
            } else {
                int space = this.source.lastIndexOf(32);
                if (space > -1) {
                    terms.add(this.source.substring(space + 1));
                } else {
                    terms.add(this.source);
                }
            }
            return terms;
        }
    }
}

