/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.slave_setup;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.slave_setup.SetupConfig;
import org.jenkinsci.plugins.slave_setup.SetupConfigItem;
import org.jenkinsci.plugins.slave_setup.SetupDeployer;
import org.jenkinsci.plugins.slave_setup.Utils;

public class Components {
    private static final String FILENAME = "slave_setup.ini";
    private FilePath remotePath;
    private List<SetupConfigItem> configs;
    private Computer slave;
    private static TaskListener listener;
    private List<String> cache;
    private static boolean debugMode;
    private FilePath configFile;
    private String remoteSeparator;

    public Components(FilePath remoteRootPath, Computer slave) throws IOException, InterruptedException {
        this.remotePath = remoteRootPath;
        this.slave = slave;
        this.Initialize();
    }

    private void Initialize() throws IOException, InterruptedException {
        this.configFile = this.remotePath.child(FILENAME);
        if (!this.configFile.exists()) {
            this.configFile.write();
            Components.debug("New config created on " + this.configFile.getRemote());
        }
        this.remoteSeparator = Utils.osLineSeparator(this.remotePath.getRemote());
        this.configs = SetupConfig.get().getSetupConfigItems();
        this.cache = this.createConfigStream();
    }

    public Components(Computer slave) throws IOException, InterruptedException {
        this.slave = slave;
        Node node = this.slave.getNode();
        if (node == null) {
            throw new InterruptedException("slave return null RootPath");
        }
        this.remotePath = node.getRootPath();
        if (this.remotePath == null) {
            throw new InterruptedException("slave return null RootPath");
        }
        this.Initialize();
    }

    public boolean newDeploy() {
        return this.getCache().size() == 0;
    }

    public static void setLogger(TaskListener listener) {
        Components.listener = listener;
    }

    private List<String> getCache() {
        if (this.cache == null) {
            this.cache = new ArrayList<String>();
        }
        return this.cache;
    }

    private void addCache(String component) {
        boolean writed = false;
        if (this.getCache().contains(component)) {
            return;
        }
        for (int i = 0; i < this.getCache().size(); ++i) {
            if (!this.cache.get(i).contains(component.split("\u00bc")[0])) continue;
            this.cache.set(i, component);
            writed = true;
            break;
        }
        if (!writed) {
            this.cache.add(component);
        }
    }

    public void doSetup() throws AbortException, IOException, InterruptedException {
        if (!this.newDeploy()) {
            Components.info("Updating existing installations for " + this.slave.getName());
        } else {
            Components.info("Executing first install for " + this.slave.getName());
        }
        Components.debug("Given cache contains this lines:\r\n " + String.join((CharSequence)this.remoteSeparator, this.cache));
        for (SetupConfigItem item : this.configs) {
            this.singleSetup(item);
        }
    }

    public void singleSetup(SetupConfigItem item) throws IOException, InterruptedException {
        if (Utils.labelMatches(item.getAssignedLabelString(), this.slave)) {
            Components.debug("Start executing scripts for " + item.getAssignedLabelString() + " with version " + item.hashCode());
            if (!this.getCache().contains(item.remoteCache())) {
                Components.info("Installing " + item.getAssignedLabelString());
                this.doDeploy(item);
                this.closeConfigStream();
                Components.info("Install " + item.getAssignedLabelString() + " succeded");
            } else {
                Components.info("%s slave have last version of %s".formatted(this.slave.getName(), item.getAssignedLabelString()));
            }
        }
    }

    public void doConfig() throws AbortException, IOException, InterruptedException {
        if (!this.newDeploy()) {
            Components.info("Updating existing installations for " + this.slave.getName());
        } else {
            Components.info("Executing first install for " + this.slave.getName());
        }
        Components.debug("Given cache contains this lines:\r\n " + String.join((CharSequence)this.remoteSeparator, this.cache));
        for (SetupConfigItem item : this.configs) {
            if (!item.getDeployNow()) continue;
            this.singleSetup(item);
        }
        this.closeConfigStream();
    }

    public static boolean doConfigSetups(List<Computer> activeSlaves) {
        boolean succeded = true;
        for (Computer slave : activeSlaves) {
            if (slave.isOffline()) {
                Components.info(slave.getName() + " is offline");
                continue;
            }
            try {
                Components manager = new Components(slave);
                manager.doConfig();
            }
            catch (Exception ex) {
                Components.info("Failed to configure %s%nErr:%s".formatted(slave.getName(), ex.getMessage()));
                succeded = false;
            }
        }
        return succeded;
    }

    public static boolean doSetups(List<Computer> activeSlaves) {
        boolean succeded = true;
        for (Computer slave : activeSlaves) {
            if (slave.isOffline()) {
                Components.info(slave.getName() + " is offline");
                continue;
            }
            try {
                Components manager = new Components(slave);
                manager.doSetup();
            }
            catch (Exception ex) {
                Components.info("Failed to configure %s%nErr:%s".formatted(slave.getName(), ex.getMessage()));
                succeded = false;
            }
        }
        return succeded;
    }

    private void doDeploy(SetupConfigItem installInfo) throws IOException, InterruptedException {
        EnvVars enviroment = SetupDeployer.createEnvVarsForComputer(this.slave);
        if (!StringUtils.isEmpty((String)installInfo.getPrepareScript())) {
            this.validateResponse(SetupDeployer.executeScriptOnMaster(listener, installInfo.getPrepareScript(), enviroment));
            installInfo.setPrepareScriptExecuted(true);
        }
        SetupDeployer.copyFiles(installInfo.getFilesDir(), this.remotePath);
        if (!StringUtils.isEmpty((String)installInfo.getCommandLine())) {
            this.validateResponse(Utils.multiOsExecutor(listener, installInfo.getCommandLine(), this.remotePath, enviroment));
        }
        this.addCache(installInfo.remoteCache());
    }

    private void validateResponse(int r) throws AbortException {
        if (r != 0) {
            Components.info("ScriptFailed " + r);
            throw new AbortException("script failed!");
        }
    }

    private void closeConfigStream() throws IOException, InterruptedException {
        if (this.getCache().size() > 0) {
            Components.debug("Updating %s with%n%s".formatted(this.configFile, StringUtils.join(this.getCache(), (String)"\r\n")));
            this.configFile.write(StringUtils.join(this.cache, (String)this.remoteSeparator).trim(), "UTF-8");
        } else {
            Components.debug("Nothing to update on slave, stream closed");
        }
    }

    private List<String> createConfigStream() throws IOException, InterruptedException {
        return new ArrayList<String>(Arrays.asList(this.configFile.readToString().split(this.remoteSeparator)));
    }

    public static void debug(String message) {
        if (debugMode) {
            Components.info(message);
        }
    }

    public static void info(String message) {
        if (listener != null) {
            listener.getLogger().println(message);
        }
    }

    public static void enableDebug() {
        debugMode = true;
    }

    public static void disableDebug() {
        debugMode = false;
    }

    static {
        debugMode = false;
    }
}

