/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.pipeline;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.CredentialsObtainer;
import jenkins.plugins.slack.Messages;
import jenkins.plugins.slack.SlackNotifier;
import jenkins.plugins.slack.cache.SlackChannelIdCache;
import jenkins.plugins.slack.pipeline.SlackFileRequest;
import jenkins.plugins.slack.pipeline.SlackUploadFileRunner;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SlackUploadFileStep
extends Step {
    private String credentialId;
    private String channel;
    private String initialComment;
    private String filePath;
    private boolean failOnError;

    @DataBoundConstructor
    public SlackUploadFileStep(String filePath) {
        this.filePath = filePath;
    }

    @DataBoundSetter
    public void setCredentialId(String credentialId) {
        this.credentialId = Util.fixEmpty((String)credentialId);
    }

    @DataBoundSetter
    public void setChannel(String channel) {
        this.channel = Util.fixEmpty((String)channel);
    }

    @DataBoundSetter
    public void setInitialComment(String initialComment) {
        this.initialComment = Util.fixEmpty((String)initialComment);
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getInitialComment() {
        return this.initialComment;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public StepExecution start(StepContext context) {
        return new SlackUploadFileStepExecution(this, context);
    }

    private static String getThreadTs(String channelName) {
        String[] splitForThread = channelName.split(":", 2);
        if (splitForThread.length == 2) {
            return splitForThread[1];
        }
        return null;
    }

    public static class SlackUploadFileStepExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient SlackUploadFileStep step;

        SlackUploadFileStepExecution(SlackUploadFileStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws IOException, InterruptedException, ExecutionException {
            String channelId;
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            FilePath filePath = (FilePath)this.getContext().get(FilePath.class);
            Item item = CredentialsObtainer.getItemForCredentials(this.getContext());
            SlackNotifier.DescriptorImpl slackDesc = (SlackNotifier.DescriptorImpl)Jenkins.get().getDescriptorByType(SlackNotifier.DescriptorImpl.class);
            String tokenCredentialId = this.step.credentialId != null ? this.step.credentialId : slackDesc.getTokenCredentialId();
            String populatedToken = CredentialsObtainer.getTokenToUse(tokenCredentialId, item, null);
            String channel = this.step.channel != null ? this.step.channel : slackDesc.getRoom();
            try {
                channelId = SlackChannelIdCache.getChannelId(populatedToken, channel);
                if (channelId == null) {
                    channelId = channel;
                }
            }
            catch (CompletionException | SlackChannelIdCache.HttpStatusCodeException e) {
                throw new AbortException("Failed uploading file to slack, channel not found: " + channel + ", error: " + e.getMessage());
            }
            String threadTs = SlackUploadFileStep.getThreadTs(channel);
            SlackFileRequest slackFileRequest = new SlackFileRequest(filePath, populatedToken, channelId, this.step.initialComment, this.step.filePath, threadTs);
            assert (filePath != null);
            VirtualChannel virtualChannel = filePath.getChannel();
            assert (virtualChannel != null);
            Boolean result = (Boolean)virtualChannel.callAsync((Callable)new SlackUploadFileRunner(listener, Jenkins.get().proxy, slackFileRequest)).get();
            if (!result.booleanValue()) {
                String errorMessage = "Failed uploading file to slack";
                if (this.step.failOnError) {
                    throw new AbortException(errorMessage);
                }
                listener.error(errorMessage);
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, FilePath.class);
        }

        public String getFunctionName() {
            return "slackUploadFile";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.slackFileUploadDisplayName();
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item) {
            return SlackNotifier.DescriptorImpl.findTokenCredentialIdItems(item);
        }
    }
}

