// CHECKSTYLE:OFF

package jenkins.plugins.slack;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code notificationFailed}: {@code Slack notification failed. See
     * Jenkins logs for details.}.
     * 
     * @return
     *     {@code Slack notification failed. See Jenkins logs for details.}
     */
    public static String notificationFailed() {
        return holder.format("notificationFailed");
    }

    /**
     * Key {@code notificationFailed}: {@code Slack notification failed. See
     * Jenkins logs for details.}.
     * 
     * @return
     *     {@code Slack notification failed. See Jenkins logs for details.}
     */
    public static Localizable _notificationFailed() {
        return new Localizable(holder, "notificationFailed");
    }

    /**
     * Key {@code slackFileUploadDisplayName}: {@code Upload file to slack}.
     * 
     * @return
     *     {@code Upload file to slack}
     */
    public static String slackFileUploadDisplayName() {
        return holder.format("slackFileUploadDisplayName");
    }

    /**
     * Key {@code slackFileUploadDisplayName}: {@code Upload file to slack}.
     * 
     * @return
     *     {@code Upload file to slack}
     */
    public static Localizable _slackFileUploadDisplayName() {
        return new Localizable(holder, "slackFileUploadDisplayName");
    }

    /**
     * Key {@code slackSendStepValues}: {@code Slack Send Pipeline step
     * running, values are - baseUrl: {0}, teamDomain: {1}, channel: {2},
     * color: {3}, botUser: {4}, tokenCredentialId: {5}, notifyCommitters:
     * {6}, iconEmoji: {7}, username: {8}, timestamp: {9}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @param arg7
     *      8th format parameter, {@code {7}}, as {@link String#valueOf(Object)}.
     * @param arg6
     *      7th format parameter, {@code {6}}, as {@link String#valueOf(Object)}.
     * @param arg9
     *      10th format parameter, {@code {9}}, as {@link String#valueOf(Object)}.
     * @param arg8
     *      9th format parameter, {@code {8}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Slack Send Pipeline step running, values are - baseUrl: {0},
     *     teamDomain: {1}, channel: {2}, color: {3}, botUser: {4},
     *     tokenCredentialId: {5}, notifyCommitters: {6}, iconEmoji: {7},
     *     username: {8}, timestamp: {9}}
     */
    public static String slackSendStepValues(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        return holder.format("slackSendStepValues", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    /**
     * Key {@code slackSendStepValues}: {@code Slack Send Pipeline step
     * running, values are - baseUrl: {0}, teamDomain: {1}, channel: {2},
     * color: {3}, botUser: {4}, tokenCredentialId: {5}, notifyCommitters:
     * {6}, iconEmoji: {7}, username: {8}, timestamp: {9}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @param arg7
     *      8th format parameter, {@code {7}}, as {@link String#valueOf(Object)}.
     * @param arg6
     *      7th format parameter, {@code {6}}, as {@link String#valueOf(Object)}.
     * @param arg9
     *      10th format parameter, {@code {9}}, as {@link String#valueOf(Object)}.
     * @param arg8
     *      9th format parameter, {@code {8}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Slack Send Pipeline step running, values are - baseUrl: {0},
     *     teamDomain: {1}, channel: {2}, color: {3}, botUser: {4},
     *     tokenCredentialId: {5}, notifyCommitters: {6}, iconEmoji: {7},
     *     username: {8}, timestamp: {9}}
     */
    public static Localizable _slackSendStepValues(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        return new Localizable(holder, "slackSendStepValues", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    /**
     * Key {@code failedToParseSlackResponse}: {@code Could not parse
     * response from slack, potentially because of invalid configuration
     * (botUser: true and baseUrl set), response: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not parse response from slack, potentially because of
     *     invalid configuration (botUser: true and baseUrl set), response: {0}}
     */
    public static String failedToParseSlackResponse(Object arg0) {
        return holder.format("failedToParseSlackResponse", arg0);
    }

    /**
     * Key {@code failedToParseSlackResponse}: {@code Could not parse
     * response from slack, potentially because of invalid configuration
     * (botUser: true and baseUrl set), response: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not parse response from slack, potentially because of
     *     invalid configuration (botUser: true and baseUrl set), response: {0}}
     */
    public static Localizable _failedToParseSlackResponse(Object arg0) {
        return new Localizable(holder, "failedToParseSlackResponse", arg0);
    }

    /**
     * Key {@code slackUserIdsFromCommittersDisplayName}: {@code Resolve
     * Slack UserIds from Changeset Authors}.
     * 
     * @return
     *     {@code Resolve Slack UserIds from Changeset Authors}
     */
    public static String slackUserIdsFromCommittersDisplayName() {
        return holder.format("slackUserIdsFromCommittersDisplayName");
    }

    /**
     * Key {@code slackUserIdsFromCommittersDisplayName}: {@code Resolve
     * Slack UserIds from Changeset Authors}.
     * 
     * @return
     *     {@code Resolve Slack UserIds from Changeset Authors}
     */
    public static Localizable _slackUserIdsFromCommittersDisplayName() {
        return new Localizable(holder, "slackUserIdsFromCommittersDisplayName");
    }

    /**
     * Key {@code slackUserIdFromEmailDisplayName}: {@code Resolve Slack
     * UserId from Email Address}.
     * 
     * @return
     *     {@code Resolve Slack UserId from Email Address}
     */
    public static String slackUserIdFromEmailDisplayName() {
        return holder.format("slackUserIdFromEmailDisplayName");
    }

    /**
     * Key {@code slackUserIdFromEmailDisplayName}: {@code Resolve Slack
     * UserId from Email Address}.
     * 
     * @return
     *     {@code Resolve Slack UserId from Email Address}
     */
    public static Localizable _slackUserIdFromEmailDisplayName() {
        return new Localizable(holder, "slackUserIdFromEmailDisplayName");
    }

    /**
     * Key {@code slackSendStepValuesEmptyMessage}: {@code <empty>}.
     * 
     * @return
     *     {@code <empty>}
     */
    public static String slackSendStepValuesEmptyMessage() {
        return holder.format("slackSendStepValuesEmptyMessage");
    }

    /**
     * Key {@code slackSendStepValuesEmptyMessage}: {@code <empty>}.
     * 
     * @return
     *     {@code <empty>}
     */
    public static Localizable _slackSendStepValuesEmptyMessage() {
        return new Localizable(holder, "slackSendStepValuesEmptyMessage");
    }

    /**
     * Key {@code baseUrlIsJenkinsCiAppUrl}: {@code You should only set the
     * override URL if you''re using a slack compatible app, please clear
     * this field and enter the workspace name instead}.
     * 
     * @return
     *     {@code You should only set the override URL if you''re using a slack
     *     compatible app, please clear this field and enter the workspace name
     *     instead}
     */
    public static String baseUrlIsJenkinsCiAppUrl() {
        return holder.format("baseUrlIsJenkinsCiAppUrl");
    }

    /**
     * Key {@code baseUrlIsJenkinsCiAppUrl}: {@code You should only set the
     * override URL if you''re using a slack compatible app, please clear
     * this field and enter the workspace name instead}.
     * 
     * @return
     *     {@code You should only set the override URL if you''re using a slack
     *     compatible app, please clear this field and enter the workspace name
     *     instead}
     */
    public static Localizable _baseUrlIsJenkinsCiAppUrl() {
        return new Localizable(holder, "baseUrlIsJenkinsCiAppUrl");
    }

    /**
     * Key {@code MatrixTriggerMode.OnlyParent}: {@code Trigger only the
     * parent job}.
     * 
     * @return
     *     {@code Trigger only the parent job}
     */
    public static String MatrixTriggerMode_OnlyParent() {
        return holder.format("MatrixTriggerMode.OnlyParent");
    }

    /**
     * Key {@code MatrixTriggerMode.OnlyParent}: {@code Trigger only the
     * parent job}.
     * 
     * @return
     *     {@code Trigger only the parent job}
     */
    public static Localizable _MatrixTriggerMode_OnlyParent() {
        return new Localizable(holder, "MatrixTriggerMode.OnlyParent");
    }

    /**
     * Key {@code slackSendStepDisplayName}: {@code Send Slack Message}.
     * 
     * @return
     *     {@code Send Slack Message}
     */
    public static String slackSendStepDisplayName() {
        return holder.format("slackSendStepDisplayName");
    }

    /**
     * Key {@code slackSendStepDisplayName}: {@code Send Slack Message}.
     * 
     * @return
     *     {@code Send Slack Message}
     */
    public static Localizable _slackSendStepDisplayName() {
        return new Localizable(holder, "slackSendStepDisplayName");
    }

    /**
     * Key {@code MatrixTriggerMode.OnlyConfigurations}: {@code Trigger for
     * each configuration}.
     * 
     * @return
     *     {@code Trigger for each configuration}
     */
    public static String MatrixTriggerMode_OnlyConfigurations() {
        return holder.format("MatrixTriggerMode.OnlyConfigurations");
    }

    /**
     * Key {@code MatrixTriggerMode.OnlyConfigurations}: {@code Trigger for
     * each configuration}.
     * 
     * @return
     *     {@code Trigger for each configuration}
     */
    public static Localizable _MatrixTriggerMode_OnlyConfigurations() {
        return new Localizable(holder, "MatrixTriggerMode.OnlyConfigurations");
    }

    /**
     * Key {@code notificationFailedWithException}: {@code Slack notification
     * failed with exception: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Slack notification failed with exception: {0}}
     */
    public static String notificationFailedWithException(Object arg0) {
        return holder.format("notificationFailedWithException", arg0);
    }

    /**
     * Key {@code notificationFailedWithException}: {@code Slack notification
     * failed with exception: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Slack notification failed with exception: {0}}
     */
    public static Localizable _notificationFailedWithException(Object arg0) {
        return new Localizable(holder, "notificationFailedWithException", arg0);
    }

    /**
     * Key {@code migratedCredentialDescription}: {@code Migrated slack
     * token}.
     * 
     * @return
     *     {@code Migrated slack token}
     */
    public static String migratedCredentialDescription() {
        return holder.format("migratedCredentialDescription");
    }

    /**
     * Key {@code migratedCredentialDescription}: {@code Migrated slack
     * token}.
     * 
     * @return
     *     {@code Migrated slack token}
     */
    public static Localizable _migratedCredentialDescription() {
        return new Localizable(holder, "migratedCredentialDescription");
    }

    /**
     * Key {@code workspaceNameAndBaseUrlSet}: {@code Only set workspace name
     * or override url not both}.
     * 
     * @return
     *     {@code Only set workspace name or override url not both}
     */
    public static String workspaceNameAndBaseUrlSet() {
        return holder.format("workspaceNameAndBaseUrlSet");
    }

    /**
     * Key {@code workspaceNameAndBaseUrlSet}: {@code Only set workspace name
     * or override url not both}.
     * 
     * @return
     *     {@code Only set workspace name or override url not both}
     */
    public static Localizable _workspaceNameAndBaseUrlSet() {
        return new Localizable(holder, "workspaceNameAndBaseUrlSet");
    }

    /**
     * Key {@code MatrixTriggerMode.Both}: {@code Trigger for parent and each
     * configuration}.
     * 
     * @return
     *     {@code Trigger for parent and each configuration}
     */
    public static String MatrixTriggerMode_Both() {
        return holder.format("MatrixTriggerMode.Both");
    }

    /**
     * Key {@code MatrixTriggerMode.Both}: {@code Trigger for parent and each
     * configuration}.
     * 
     * @return
     *     {@code Trigger for parent and each configuration}
     */
    public static Localizable _MatrixTriggerMode_Both() {
        return new Localizable(holder, "MatrixTriggerMode.Both");
    }

}
