/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.workflow;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.json.JsonOutput;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.CredentialsObtainer;
import jenkins.plugins.slack.Messages;
import jenkins.plugins.slack.SlackNotifier;
import jenkins.plugins.slack.SlackRequest;
import jenkins.plugins.slack.SlackService;
import jenkins.plugins.slack.StandardSlackService;
import jenkins.plugins.slack.StandardSlackServiceBuilder;
import jenkins.plugins.slack.user.SlackUserIdResolver;
import jenkins.plugins.slack.workflow.SlackResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.json.JSONException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SlackSendStep
extends Step {
    private static final Logger logger = Logger.getLogger(SlackSendStep.class.getName());
    private String message;
    private String timestamp;
    private String color;
    private String token;
    private String tokenCredentialId;
    private boolean botUser;
    private String channel;
    private String baseUrl;
    private String teamDomain;
    private boolean failOnError;
    private Object attachments;
    private Object blocks;
    private boolean replyBroadcast;
    private boolean sendAsText;
    private String iconEmoji;
    private String username;
    private boolean notifyCommitters;

    @NonNull
    public String getMessage() {
        return this.message;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getColor() {
        return this.color;
    }

    @DataBoundSetter
    public void setColor(String color) {
        this.color = Util.fixEmpty((String)color);
    }

    public String getToken() {
        return this.token;
    }

    @DataBoundSetter
    public void setToken(String token) {
        this.token = Util.fixEmpty((String)token);
    }

    public String getTokenCredentialId() {
        return this.tokenCredentialId;
    }

    @DataBoundSetter
    public void setTokenCredentialId(String tokenCredentialId) {
        this.tokenCredentialId = Util.fixEmpty((String)tokenCredentialId);
    }

    public boolean getBotUser() {
        return this.botUser;
    }

    @DataBoundSetter
    public void setBotUser(boolean botUser) {
        this.botUser = botUser;
    }

    public String getChannel() {
        return this.channel;
    }

    @DataBoundSetter
    public void setChannel(String channel) {
        this.channel = Util.fixEmpty((String)channel);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @DataBoundSetter
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = Util.fixEmpty((String)baseUrl);
        if (this.baseUrl != null && !this.baseUrl.isEmpty() && !this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
    }

    public String getTeamDomain() {
        return this.teamDomain;
    }

    @DataBoundSetter
    public void setTeamDomain(String teamDomain) {
        this.teamDomain = Util.fixEmpty((String)teamDomain);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @DataBoundSetter
    public void setAttachments(Object attachments) {
        this.attachments = attachments;
    }

    public Object getAttachments() {
        return this.attachments;
    }

    public Object getBlocks() {
        return this.blocks;
    }

    @DataBoundSetter
    public void setBlocks(Object blocks) {
        this.blocks = blocks;
    }

    @DataBoundSetter
    public void setMessage(String message) {
        this.message = Util.fixEmpty((String)message);
    }

    @DataBoundSetter
    public void setTimestamp(String timestamp) {
        this.timestamp = Util.fixEmpty((String)timestamp);
    }

    public boolean getReplyBroadcast() {
        return this.replyBroadcast;
    }

    @DataBoundSetter
    public void setReplyBroadcast(boolean replyBroadcast) {
        this.replyBroadcast = replyBroadcast;
    }

    public boolean getSendAsText() {
        return this.sendAsText;
    }

    @DataBoundSetter
    public void setSendAsText(boolean sendAsText) {
        this.sendAsText = sendAsText;
    }

    @DataBoundConstructor
    public SlackSendStep() {
    }

    public String getIconEmoji() {
        return this.iconEmoji;
    }

    @DataBoundSetter
    public void setIconEmoji(String iconEmoji) {
        this.iconEmoji = Util.fixEmpty((String)iconEmoji);
    }

    public String getUsername() {
        return this.username;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = Util.fixEmpty((String)username);
    }

    public boolean getNotifyCommitters() {
        return this.notifyCommitters;
    }

    @DataBoundSetter
    public void setNotifyCommitters(boolean notifyCommitters) {
        this.notifyCommitters = notifyCommitters;
    }

    public StepExecution start(StepContext context) {
        return new SlackSendStepExecution(this, context);
    }

    public static class SlackSendStepExecution
    extends SynchronousNonBlockingStepExecution<SlackResponse> {
        private static final long serialVersionUID = 1L;
        private final transient SlackSendStep step;

        SlackSendStepExecution(SlackSendStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected SlackResponse run() throws Exception {
            boolean publishSuccess;
            String populatedToken;
            Jenkins jenkins = Jenkins.get();
            Item item = CredentialsObtainer.getItemForCredentials(this.getContext());
            SlackNotifier.DescriptorImpl slackDesc = (SlackNotifier.DescriptorImpl)jenkins.getDescriptorByType(SlackNotifier.DescriptorImpl.class);
            String baseUrl = this.step.baseUrl != null ? this.step.baseUrl : slackDesc.getBaseUrl();
            String teamDomain = this.step.teamDomain != null ? this.step.teamDomain : slackDesc.getTeamDomain();
            String tokenCredentialId = this.step.tokenCredentialId != null ? this.step.tokenCredentialId : slackDesc.getTokenCredentialId();
            String token = this.step.token;
            boolean botUser = this.step.botUser || slackDesc.isBotUser();
            String channel = this.step.channel != null ? this.step.channel : slackDesc.getRoom();
            String color = this.step.color != null ? this.step.color : "";
            boolean sendAsText = this.step.sendAsText || slackDesc.isSendAsText();
            String iconEmoji = this.step.iconEmoji != null ? this.step.iconEmoji : slackDesc.getIconEmoji();
            String username = this.step.username != null ? this.step.username : slackDesc.getUsername();
            boolean notifyCommitters = this.step.notifyCommitters;
            SlackUserIdResolver userIdResolver = slackDesc.getSlackUserIdResolver();
            Run run = (Run)this.getContext().get(Run.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            Objects.requireNonNull(listener, "Listener is mandatory here");
            listener.getLogger().println(Messages.slackSendStepValues(this.defaultIfEmpty(baseUrl), this.defaultIfEmpty(teamDomain), channel, this.defaultIfEmpty(color), botUser, this.defaultIfEmpty(tokenCredentialId), notifyCommitters, this.defaultIfEmpty(iconEmoji), this.defaultIfEmpty(username), this.defaultIfEmpty(this.step.timestamp)));
            try {
                populatedToken = CredentialsObtainer.getTokenToUse(tokenCredentialId, item, token);
            }
            catch (IllegalArgumentException e) {
                listener.error(Messages.notificationFailedWithException(e));
                return null;
            }
            SlackService slackService = this.getSlackService(run, baseUrl, teamDomain, botUser, channel, this.step.replyBroadcast, sendAsText, iconEmoji, username, populatedToken, notifyCommitters, userIdResolver);
            if (sendAsText) {
                publishSuccess = this.step.timestamp != null ? slackService.publish(this.step.message, new JSONArray(), color, this.step.timestamp) : slackService.publish(this.step.message, new JSONArray(), color);
            } else if (this.step.attachments != null || this.step.blocks != null) {
                SlackRequest.SlackRequestBuilder requestBuilder = SlackRequest.builder().withMessage(this.step.message).withTimestamp(this.step.timestamp);
                if (this.step.attachments != null) {
                    JSONArray attachmentsJsonArray = this.getAttachmentsAsJSONArray();
                    for (Object object : attachmentsJsonArray) {
                        JSONObject jsonNode;
                        if (!(object instanceof JSONObject) || (jsonNode = (JSONObject)object).has("fallback")) continue;
                        jsonNode.put("fallback", (Object)this.step.message);
                    }
                    requestBuilder = requestBuilder.withAttachments(attachmentsJsonArray).withColor(color);
                }
                if (this.step.blocks != null) {
                    JSONArray blocksJsonArray = this.getBlocksAsJSONArray();
                    requestBuilder = requestBuilder.withBlocks(blocksJsonArray);
                }
                publishSuccess = slackService.publish(requestBuilder.build());
            } else if (this.step.message != null) {
                publishSuccess = this.step.timestamp != null ? slackService.publish(this.step.message, color, this.step.timestamp) : slackService.publish(this.step.message, color);
            } else {
                listener.error(Messages.notificationFailedWithException(new IllegalArgumentException("No message, attachments or blocks provided")));
                if (!this.step.isFailOnError()) return null;
                run.setResult(Result.FAILURE);
                throw new AbortException("No message, attachments or blocks provided");
            }
            SlackResponse response = null;
            String responseString = slackService.getResponseString();
            if (publishSuccess) {
                if (responseString == null) return new SlackResponse(slackService);
                try {
                    org.json.JSONObject result = new org.json.JSONObject(responseString);
                    return new SlackResponse(result, slackService);
                }
                catch (JSONException ex) {
                    listener.error(Messages.failedToParseSlackResponse(responseString));
                    if (!this.step.failOnError) return response;
                    run.setResult(Result.FAILURE);
                    throw ex;
                }
            }
            if (this.step.failOnError) {
                run.setResult(Result.FAILURE);
                if (responseString == null) throw new AbortException(Messages.notificationFailed());
                throw new AbortException(Messages.notificationFailedWithException(responseString));
            }
            if (responseString != null) {
                listener.error(Messages.notificationFailedWithException(responseString));
            }
            listener.error(Messages.notificationFailed());
            return response;
        }

        JSONArray getBlocksAsJSONArray() throws Exception {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            String jsonString = JsonOutput.toJson((Object)this.step.blocks);
            return this.convertStringToJsonArray(listener, jsonString, "Blocks");
        }

        private JSONArray convertStringToJsonArray(TaskListener listener, String jsonString, String fieldType) {
            try {
                return JSONArray.fromObject((Object)jsonString);
            }
            catch (net.sf.json.JSONException e) {
                listener.error(Messages.notificationFailedWithException((Object)e));
                return null;
            }
        }

        JSONArray getAttachmentsAsJSONArray() throws Exception {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            String jsonString = this.step.attachments instanceof String ? (String)this.step.attachments : JsonOutput.toJson((Object)this.step.attachments);
            return this.convertStringToJsonArray(listener, jsonString, "Attachments");
        }

        private String defaultIfEmpty(String value) {
            return Util.fixEmpty((String)value) != null ? value : Messages.slackSendStepValuesEmptyMessage();
        }

        SlackService getSlackService(Run run, String baseUrl, String team, boolean botUser, String channel, boolean replyBroadcast, boolean sendAsText, String iconEmoji, String username, String populatedToken, boolean notifyCommitters, SlackUserIdResolver userIdResolver) {
            return new StandardSlackService(new StandardSlackServiceBuilder().withRun(run).withBaseUrl(baseUrl).withTeamDomain(team).withBotUser(botUser).withRoomId(channel).withReplyBroadcast(replyBroadcast).withIconEmoji(iconEmoji).withUsername(username).withPopulatedToken(populatedToken).withNotifyCommitters(notifyCommitters).withSlackUserIdResolver(userIdResolver));
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "slackSend";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.slackSendStepDisplayName();
        }

        public ListBoxModel doFillTokenCredentialIdItems(@AncestorInPath Item item) {
            return SlackNotifier.DescriptorImpl.findTokenCredentialIdItems(item);
        }
    }
}

