/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import com.google.common.annotations.VisibleForTesting;
import hudson.AbortException;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.CredentialsObtainer;
import jenkins.plugins.slack.HttpClient;
import jenkins.plugins.slack.SlackReactionRequest;
import jenkins.plugins.slack.SlackRequest;
import jenkins.plugins.slack.SlackService;
import jenkins.plugins.slack.StandardSlackServiceBuilder;
import jenkins.plugins.slack.cache.SlackChannelIdCache;
import jenkins.plugins.slack.pipeline.SlackFileRequest;
import jenkins.plugins.slack.pipeline.SlackUploadFileRunner;
import jenkins.plugins.slack.user.SlackUserIdResolver;
import net.sf.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.json.JSONException;
import org.json.JSONObject;

public class StandardSlackService
implements SlackService {
    private static final Logger logger = Logger.getLogger(StandardSlackService.class.getName());
    static final Pattern JENKINS_CI_HOOK_REGEX = Pattern.compile("https://(?<teamDomain>.*)\\.slack\\.com/services/hooks/jenkins-ci.*");
    private final Run run;
    private String baseUrl;
    private String teamDomain;
    private boolean botUser;
    private final List<String> roomIds;
    private final boolean replyBroadcast;
    private final String iconEmoji;
    private final String username;
    private String responseString;
    private String populatedToken;
    private final boolean notifyCommitters;
    private final SlackUserIdResolver userIdResolver;

    @Deprecated
    public StandardSlackService(String baseUrl, String teamDomain, String authTokenCredentialId, boolean botUser, String roomId) {
        this(baseUrl, teamDomain, null, authTokenCredentialId, botUser, roomId, false);
    }

    @Deprecated
    public StandardSlackService(String baseUrl, String teamDomain, String token, String authTokenCredentialId, boolean botUser, String roomId) {
        this(baseUrl, teamDomain, token, authTokenCredentialId, botUser, roomId, false);
    }

    @Deprecated
    public StandardSlackService(String baseUrl, String teamDomain, String token, String authTokenCredentialId, boolean botUser, String roomId, boolean replyBroadcast) {
        this(baseUrl, teamDomain, botUser, roomId, replyBroadcast, authTokenCredentialId);
        this.populatedToken = this.getTokenToUse(authTokenCredentialId, token);
        if (this.populatedToken == null) {
            throw new IllegalArgumentException("No slack token found, setup a secret text credential and configure it to be used");
        }
    }

    @Deprecated
    public StandardSlackService(String baseUrl, String teamDomain, boolean botUser, String roomId, boolean replyBroadcast, String populatedToken) {
        this(StandardSlackService.builder().withBaseUrl(baseUrl).withTeamDomain(teamDomain).withBotUser(botUser).withRoomId(roomId).withReplyBroadcast(replyBroadcast).withPopulatedToken(populatedToken));
        if (populatedToken == null) {
            throw new IllegalArgumentException("No slack token found, setup a secret text credential and configure it to be used");
        }
        this.populatedToken = populatedToken;
    }

    public StandardSlackService(StandardSlackServiceBuilder standardSlackServiceBuilder) {
        this.run = standardSlackServiceBuilder.run;
        this.baseUrl = standardSlackServiceBuilder.baseUrl;
        if (this.baseUrl != null && !this.baseUrl.isEmpty() && !this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
        this.teamDomain = standardSlackServiceBuilder.teamDomain;
        this.botUser = standardSlackServiceBuilder.botUser;
        if (standardSlackServiceBuilder.roomId == null) {
            throw new IllegalArgumentException("Project Channel or Slack User ID must be specified.");
        }
        this.roomIds = new ArrayList<String>(Arrays.asList(standardSlackServiceBuilder.roomId.split("[,; ]+")));
        this.replyBroadcast = standardSlackServiceBuilder.replyBroadcast;
        this.iconEmoji = this.correctEmojiFormat(standardSlackServiceBuilder.iconEmoji);
        this.username = standardSlackServiceBuilder.username;
        this.populatedToken = standardSlackServiceBuilder.populatedToken;
        this.notifyCommitters = standardSlackServiceBuilder.notifyCommitters;
        this.userIdResolver = standardSlackServiceBuilder.userIdResolver;
    }

    public static StandardSlackServiceBuilder builder() {
        return new StandardSlackServiceBuilder();
    }

    @Override
    public String getResponseString() {
        return this.responseString;
    }

    @Override
    public boolean publish(String message) {
        return this.publish(message, "warning");
    }

    void correctMisconfigurationOfBaseUrl() {
        Matcher matcher = JENKINS_CI_HOOK_REGEX.matcher(this.baseUrl);
        if (StringUtils.isNotEmpty((CharSequence)this.baseUrl) && matcher.matches()) {
            this.teamDomain = matcher.group("teamDomain");
            logger.warning("Overriding base url to team domain '" + this.teamDomain + "' this is due to mis-configuration, you don't need to set base url unless you're using a slack compatible app like mattermost");
            this.botUser = false;
        }
    }

    boolean postToSlack(String apiEndpoint, net.sf.json.JSONObject body) {
        boolean result = true;
        if (this.baseUrl != null) {
            this.correctMisconfigurationOfBaseUrl();
        }
        try (CloseableHttpClient client = this.getHttpClient();){
            HttpPost post;
            if (!this.botUser) {
                String url = "https://" + this.teamDomain + ".slack.com/services/hooks/jenkins-ci?token=" + this.populatedToken;
                if (!StringUtils.isEmpty((CharSequence)this.baseUrl)) {
                    url = this.baseUrl + this.populatedToken;
                }
                post = new HttpPost(url);
            } else {
                String url = "https://slack.com/api/" + apiEndpoint;
                post = new HttpPost(url);
                post.setHeader("Authorization", (Object)("Bearer " + this.populatedToken));
            }
            post.setHeader("Content-Type", (Object)"application/json; charset=utf-8");
            post.setEntity((HttpEntity)new StringEntity(body.toString(), StandardCharsets.UTF_8));
            try (CloseableHttpResponse response = client.execute((ClassicHttpRequest)post);){
                int responseCode = response.getCode();
                HttpEntity entity = response.getEntity();
                if (this.botUser && entity != null) {
                    this.responseString = EntityUtils.toString((HttpEntity)entity);
                    try {
                        JSONObject slackResponse = new JSONObject(this.responseString);
                        result = slackResponse.getBoolean("ok");
                    }
                    catch (JSONException ex) {
                        logger.log(Level.WARNING, "Slack post may have failed.  Invalid JSON response: " + this.responseString);
                        result = false;
                    }
                }
                if (responseCode != 200 || !result) {
                    logger.log(Level.WARNING, "Slack post may have failed. Response: " + this.responseString);
                    logger.log(Level.WARNING, "Response Code: " + responseCode);
                    result = false;
                } else {
                    logger.fine("Posting succeeded");
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error posting to Slack", e);
                result = false;
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing HttpClient", e);
        }
        return result;
    }

    @Override
    public boolean upload(FilePath workspace, String artifactIncludes, TaskListener log) {
        boolean result = true;
        if (workspace != null) {
            for (String roomId : this.roomIds) {
                String channelId;
                try {
                    channelId = SlackChannelIdCache.getChannelId(this.populatedToken, roomId);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (AbortException e) {
                    return false;
                }
                SlackFileRequest slackFileRequest = new SlackFileRequest(workspace, this.populatedToken, channelId, null, artifactIncludes, null);
                try {
                    workspace.getChannel().callAsync((Callable)new SlackUploadFileRunner(log, Jenkins.get().proxy, slackFileRequest)).get();
                }
                catch (IllegalStateException | InterruptedException e) {
                    logger.log(Level.WARNING, "Exception", e);
                    result = false;
                }
                catch (ExecutionException e) {
                    logger.log(Level.WARNING, "ExecutionException", e);
                    result = false;
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Error closing HttpClient", e);
                    result = false;
                }
            }
        } else {
            logger.log(Level.WARNING, "Could not get workspace for current execution");
            result = false;
        }
        return result;
    }

    @Override
    public boolean publish(SlackRequest slackRequest) {
        boolean result = true;
        try (CloseableHttpClient client = this.getHttpClient();){
            if (this.botUser && this.notifyCommitters && this.userIdResolver != null && this.run != null) {
                this.userIdResolver.setAuthToken(this.populatedToken);
                this.userIdResolver.setHttpClient(client);
                List<String> userIds = this.userIdResolver.resolveUserIdsForRun(this.run);
                this.roomIds.addAll(userIds.stream().filter(Objects::nonNull).distinct().map(userId -> "@" + userId).collect(Collectors.toList()));
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing HttpClient", e);
        }
        for (String roomId : this.roomIds) {
            String threadTs = "";
            String[] splitThread = roomId.split("[:]+");
            if (splitThread.length > 1) {
                roomId = splitThread[0];
                threadTs = splitThread[1];
            }
            net.sf.json.JSONObject json = slackRequest.getBody();
            json.put("channel", (Object)roomId);
            if (threadTs.length() > 1) {
                json.put("thread_ts", (Object)threadTs);
            }
            if (this.replyBroadcast) {
                json.put("reply_broadcast", (Object)"true");
            }
            if (StringUtils.isEmpty((CharSequence)this.iconEmoji) && StringUtils.isEmpty((CharSequence)this.username)) {
                json.put("as_user", (Object)"true");
            } else {
                if (StringUtils.isNotEmpty((CharSequence)this.iconEmoji)) {
                    json.put("icon_emoji", (Object)this.iconEmoji);
                }
                if (StringUtils.isNotEmpty((CharSequence)this.username)) {
                    json.put("username", (Object)this.username);
                }
            }
            String apiEndpoint = "chat.postMessage";
            String timestamp = slackRequest.getTimestamp();
            if (StringUtils.isNotEmpty((CharSequence)timestamp)) {
                json.put("ts", (Object)timestamp);
                apiEndpoint = "chat.update";
            }
            logger.fine("Posting: to " + roomId + " on " + this.teamDomain + ":  " + json.toString());
            boolean individualResult = this.postToSlack(apiEndpoint, json);
            result = result && individualResult;
        }
        return result;
    }

    @Override
    public boolean publish(String message, String color) {
        JSONArray attachments = this.prepareAttachments(message, color);
        return this.publish(null, attachments, color);
    }

    private JSONArray prepareAttachments(String message, String color) {
        net.sf.json.JSONObject field = new net.sf.json.JSONObject();
        field.put("short", (Object)false);
        field.put("value", (Object)message);
        JSONArray fields = new JSONArray();
        fields.add((Object)field);
        net.sf.json.JSONObject attachment = new net.sf.json.JSONObject();
        attachment.put("fallback", (Object)message);
        attachment.put("color", (Object)color);
        attachment.put("fields", (Object)fields);
        JSONArray mrkdwn = new JSONArray();
        mrkdwn.add((Object)"pretext");
        mrkdwn.add((Object)"text");
        mrkdwn.add((Object)"fields");
        attachment.put("mrkdwn_in", (Object)mrkdwn);
        JSONArray attachments = new JSONArray();
        attachments.add((Object)attachment);
        return attachments;
    }

    @Override
    public boolean publish(String message, JSONArray attachments, String color) {
        return this.publish(SlackRequest.builder().withMessage(message).withAttachments(attachments).withColor(color).build());
    }

    @Override
    public boolean publish(String message, String color, String timestamp) {
        JSONArray attachments = this.prepareAttachments(message, color);
        return this.publish(null, attachments, color, timestamp);
    }

    @Override
    public boolean publish(String message, JSONArray attachments, String color, String timestamp) {
        return this.publish(SlackRequest.builder().withMessage(message).withTimestamp(timestamp).withAttachments(attachments).withColor(color).build());
    }

    @Override
    public boolean addReaction(String channelId, String timestamp, String emojiName) {
        net.sf.json.JSONObject json = SlackReactionRequest.builder().withChannelId(channelId).withTimestamp(timestamp).withEmojiName(emojiName).build().getBody();
        logger.fine("Adding reaction:  " + json.toString());
        return this.postToSlack("reactions.add", json);
    }

    @Override
    public boolean removeReaction(String channelId, String timestamp, String emojiName) {
        net.sf.json.JSONObject json = SlackReactionRequest.builder().withChannelId(channelId).withTimestamp(timestamp).withEmojiName(emojiName).build().getBody();
        logger.fine("Removing reaction:  " + json.toString());
        return this.postToSlack("reactions.remove", json);
    }

    private String getTokenToUse(String authTokenCredentialId, String token) {
        StringCredentials credentials;
        if (!StringUtils.isEmpty((CharSequence)authTokenCredentialId) && (credentials = CredentialsObtainer.lookupCredentials(authTokenCredentialId)) != null) {
            logger.fine("Using Integration Token Credential ID.");
            return credentials.getSecret().getPlainText();
        }
        logger.fine("Using Integration Token.");
        return token;
    }

    private String correctEmojiFormat(String iconEmoji) {
        if (StringUtils.isEmpty((CharSequence)iconEmoji)) {
            return iconEmoji;
        }
        iconEmoji = StringUtils.appendIfMissing((String)iconEmoji, (CharSequence)":", (CharSequence[])new CharSequence[0]);
        iconEmoji = StringUtils.prependIfMissing((String)iconEmoji, (CharSequence)":", (CharSequence[])new CharSequence[0]);
        return iconEmoji;
    }

    protected CloseableHttpClient getHttpClient() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        ProxyConfiguration proxy = jenkins != null ? jenkins.proxy : null;
        return HttpClient.getCloseableHttpClient(proxy);
    }

    @VisibleForTesting
    String getTeamDomain() {
        return this.teamDomain;
    }
}

