/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import hudson.ProxyConfiguration;
import hudson.util.Secret;
import jenkins.plugins.slack.NoProxyHostCheckerRoutePlanner;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.Timeout;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class HttpClient {
    public static HttpClientBuilder getCloseableHttpClientBuilder(ProxyConfiguration proxy) {
        int timeoutInSeconds = 60;
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)timeoutInSeconds)).setSocketTimeout(Timeout.ofSeconds((long)timeoutInSeconds)).build();
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connectionConfig).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)timeoutInSeconds)).build();
        HttpClientBuilder clientBuilder = HttpClients.custom().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        if (proxy != null) {
            HttpHost proxyHost = new HttpHost(proxy.name, proxy.port);
            NoProxyHostCheckerRoutePlanner routePlanner = new NoProxyHostCheckerRoutePlanner(proxy.getNoProxyHost(), proxyHost);
            clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            String username = proxy.getUserName();
            Secret secretPassword = proxy.getSecretPassword();
            String password = Secret.toString((Secret)secretPassword);
            if (username != null && !username.trim().isEmpty()) {
                credentialsProvider.setCredentials(new AuthScope(proxyHost), HttpClient.createCredentials(username, password));
            }
        }
        return clientBuilder;
    }

    public static CloseableHttpClient getCloseableHttpClient(ProxyConfiguration proxy) {
        return HttpClient.getCloseableHttpClientBuilder(proxy).build();
    }

    private static Credentials createCredentials(String userName, String password) {
        if (userName.indexOf(92) >= 0) {
            String domain = userName.substring(0, userName.indexOf(92));
            String user = userName.substring(userName.indexOf(92) + 1);
            return new NTCredentials(user, password.toCharArray(), "", domain);
        }
        return new UsernamePasswordCredentials(userName, password.toCharArray());
    }
}

