/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.decisions;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.tasks.junit.TestResultAction;
import jenkins.plugins.slack.logging.BuildKey;

public class Context {
    private final AbstractBuild<?, ?> current;
    private final AbstractBuild<?, ?> previous;

    public Context(AbstractBuild<?, ?> current, AbstractBuild<?, ?> previous) {
        this.current = current;
        this.previous = previous;
    }

    public String currentKey() {
        return BuildKey.format(this.current);
    }

    public Result previousResultOrSuccess() {
        if (this.previous == null || this.previous.getResult() == null) {
            return Result.SUCCESS;
        }
        return this.previous.getResult();
    }

    @Nullable
    public Result currentResult() {
        if (this.current == null) {
            return null;
        }
        return this.current.getResult();
    }

    public Result currentResultOrSuccess() {
        if (this.current == null || this.current.getResult() == null) {
            return Result.SUCCESS;
        }
        return this.current.getResult();
    }

    @Nullable
    private TestResultAction getTestResult(AbstractBuild<?, ?> build) {
        if (build == null) {
            return null;
        }
        return (TestResultAction)build.getAction(TestResultAction.class);
    }

    @Nullable
    public TestResultAction getPreviousTestResult() {
        return this.getTestResult(this.previous);
    }

    @Nullable
    public TestResultAction getCurrentTestResult() {
        return this.getTestResult(this.current);
    }
}

