/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import hudson.ProxyConfiguration;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;

public class NoProxyHostCheckerRoutePlanner
implements HttpRoutePlanner {
    private DefaultProxyRoutePlanner defaultProxyRoutePlanner = null;
    private DefaultRoutePlanner defaultRoutePlanner = null;
    private String noProxyHost = null;

    public NoProxyHostCheckerRoutePlanner(String noProxyHost, HttpHost host) {
        this.defaultProxyRoutePlanner = new DefaultProxyRoutePlanner(host);
        this.defaultRoutePlanner = new DefaultRoutePlanner((SchemePortResolver)new DefaultSchemePortResolver());
        this.noProxyHost = noProxyHost;
    }

    public void setProxy(HttpHost host) {
        this.defaultProxyRoutePlanner = new DefaultProxyRoutePlanner(host);
    }

    public HttpRoute determineRoute(HttpHost target, HttpContext context) throws HttpException {
        String targetHostUri = target.toURI();
        if (this.isNoProxyHost(targetHostUri)) {
            return this.defaultRoutePlanner.determineRoute(target, context);
        }
        return this.defaultProxyRoutePlanner.determineRoute(target, context);
    }

    private boolean isNoProxyHost(String host) {
        if (host != null && this.noProxyHost != null) {
            for (Pattern p : ProxyConfiguration.getNoProxyHostPatterns((String)this.noProxyHost)) {
                if (!p.matcher(host).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

