/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.user;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.scm.ChangeLogSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.user.SlackUserIdResolverDescriptor;
import jenkins.plugins.slack.user.SlackUserProperty;
import jenkins.scm.RunWithSCM;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;

public abstract class SlackUserIdResolver
extends AbstractDescribableImpl<SlackUserIdResolver>
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(SlackUserIdResolver.class.getName());
    protected String authToken;
    protected CloseableHttpClient httpClient;

    protected SlackUserIdResolver(String authToken, CloseableHttpClient httpClient) {
        this.authToken = authToken;
        this.httpClient = httpClient;
    }

    public final String findOrResolveUserId(User user) {
        String userId = null;
        SlackUserProperty userProperty = (SlackUserProperty)user.getProperty(SlackUserProperty.class);
        if (userProperty != null) {
            userId = userProperty.getUserId();
        } else {
            userProperty = new SlackUserProperty();
        }
        if (StringUtils.isEmpty((CharSequence)userId) && (userId = this.resolveUserId(user)) != null) {
            userProperty.setUserId(userId);
            try {
                user.addProperty((UserProperty)userProperty);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Failed to add SlackUserProperty to user: " + user.toString(), ex);
            }
        }
        boolean enableNotifications = !userProperty.getDisableNotifications();
        return enableNotifications ? userId : null;
    }

    protected abstract String resolveUserId(User var1);

    public List<String> resolveUserIdsForRun(Run run) {
        if (run instanceof RunWithSCM) {
            RunWithSCM r = (RunWithSCM)run;
            return this.resolveUserIdsForChangeLogSets(r.getChangeSets());
        }
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            return this.resolveUserIdsForChangeLogSets(build.getChangeSets());
        }
        return Collections.emptyList();
    }

    public List<String> resolveUserIdsForChangeLogSet(ChangeLogSet changeLogSet) {
        return Arrays.stream(changeLogSet.getItems()).map(item -> this.findOrResolveUserId(((ChangeLogSet.Entry)item).getAuthor())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<String> resolveUserIdsForChangeLogSets(List<ChangeLogSet> changeLogSets) {
        return changeLogSets.stream().map(this::resolveUserIdsForChangeLogSet).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public SlackUserIdResolverDescriptor getDescriptor() {
        return (SlackUserIdResolverDescriptor)super.getDescriptor();
    }

    public static ExtensionList<SlackUserIdResolver> all() {
        return Jenkins.get().getExtensionList(SlackUserIdResolver.class);
    }
}

