/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.logging;

import hudson.model.TaskListener;
import java.util.logging.Logger;
import jenkins.plugins.slack.logging.BuildAwareLogger;

public class SlackNotificationsLogger
implements BuildAwareLogger {
    private static final String PLUGIN_KEY = String.format("[%s]", "Slack Notifications");
    private final Logger system;
    private final TaskListener user;

    public SlackNotificationsLogger(Logger system, TaskListener listener) {
        this.system = system;
        this.user = listener;
    }

    @Override
    public void debug(String key, String message, Object ... args) {
        this.system.fine(() -> String.join((CharSequence)" ", key, String.format(message, args)));
    }

    @Override
    public void info(String key, String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        this.system.info(() -> String.join((CharSequence)" ", key, formattedMessage));
        this.user.getLogger().println(String.join((CharSequence)" ", PLUGIN_KEY, formattedMessage));
    }

    @Override
    public TaskListener getTaskListener() {
        return this.user;
    }
}

