/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import java.util.Objects;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class SlackRequest {
    private final String message;
    private final String color;
    private final String timestamp;
    private final JSONArray attachments;
    private final JSONArray blocks;

    private SlackRequest(String message, String color, JSONArray attachments, JSONArray blocks, String timestamp) {
        if (blocks != null && attachments == null && color != null) {
            throw new IllegalArgumentException("Color is not supported when blocks are set");
        }
        this.message = message;
        this.color = color;
        this.attachments = attachments;
        this.blocks = blocks;
        this.timestamp = timestamp;
    }

    public static SlackRequestBuilder builder() {
        return new SlackRequestBuilder();
    }

    public JSONObject getBody() {
        JSONObject json = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)this.message)) {
            json.put("text", (Object)this.message);
        }
        if (this.attachments != null && !this.attachments.isEmpty()) {
            json.put("attachments", (Object)this.attachments);
        }
        if (this.blocks != null && !this.blocks.isEmpty()) {
            json.put("blocks", (Object)this.blocks);
        }
        json.put("link_names", (Object)"1");
        json.put("unfurl_links", (Object)"true");
        json.put("unfurl_media", (Object)"true");
        if (StringUtils.isNotEmpty((CharSequence)this.timestamp)) {
            json.put("ts", (Object)this.timestamp);
        }
        return json;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getColor() {
        return this.color;
    }

    public JSONArray getAttachments() {
        return this.attachments;
    }

    public JSONArray getBlocks() {
        return this.blocks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackRequest that = (SlackRequest)o;
        return Objects.equals(this.message, that.message) && Objects.equals(this.color, that.color) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.attachments, that.attachments) && Objects.equals(this.blocks, that.blocks);
    }

    public String toString() {
        return String.format("SlackRequest{message='%s', color='%s', attachments=%s, blocks=%s, timestamp='%s'}", this.message, this.color, this.attachments, this.blocks, this.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.color, this.attachments, this.blocks, this.timestamp);
    }

    public static class SlackRequestBuilder {
        private String message;
        private String color;
        private String timestamp;
        private JSONArray attachments;
        private JSONArray blocks;

        private SlackRequestBuilder() {
        }

        public SlackRequestBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        public SlackRequestBuilder withColor(String color) {
            this.color = color;
            return this;
        }

        public SlackRequestBuilder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SlackRequestBuilder withAttachments(JSONArray attachments) {
            this.attachments = attachments;
            return this;
        }

        public SlackRequestBuilder withBlocks(JSONArray blocks) {
            this.blocks = blocks;
            return this;
        }

        public SlackRequest build() {
            return new SlackRequest(this.message, this.color, this.attachments, this.blocks, this.timestamp);
        }
    }
}

