/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.ActiveNotifier;
import jenkins.plugins.slack.CommitInfoChoice;
import jenkins.plugins.slack.CredentialsObtainer;
import jenkins.plugins.slack.JenkinsTokenExpander;
import jenkins.plugins.slack.Messages;
import jenkins.plugins.slack.SlackNotifierBuilder;
import jenkins.plugins.slack.SlackService;
import jenkins.plugins.slack.StandardSlackService;
import jenkins.plugins.slack.StandardSlackServiceBuilder;
import jenkins.plugins.slack.cache.SlackChannelIdCache;
import jenkins.plugins.slack.config.GlobalCredentialMigrator;
import jenkins.plugins.slack.logging.BuildAwareLogger;
import jenkins.plugins.slack.logging.BuildKey;
import jenkins.plugins.slack.logging.SlackNotificationsLogger;
import jenkins.plugins.slack.matrix.MatrixTriggerMode;
import jenkins.plugins.slack.user.SlackUserIdResolver;
import jenkins.plugins.slack.user.SlackUserIdResolverDescriptor;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class SlackNotifier
extends Notifier {
    public static final String MATRIX_PROJECT_CLASS_NAME = "hudson.matrix.MatrixProject";
    public static final String MATRIX_RUN_CLASS_NAME = "hudson.matrix.MatrixRun";
    private static final Logger logger = Logger.getLogger(SlackNotifier.class.getName());
    private String baseUrl;
    private String teamDomain;
    private String authToken;
    private String tokenCredentialId;
    private boolean botUser;
    private String room;
    private String sendAs;
    private boolean sendAsText;
    private String iconEmoji;
    private String username;
    private boolean startNotification;
    private boolean notifySuccess;
    private boolean notifyAborted;
    private boolean notifyNotBuilt;
    private boolean notifyUnstable;
    private boolean notifyRegression;
    private boolean notifyFailure;
    private boolean notifyEveryFailure;
    private boolean notifyBackToNormal;
    private boolean notifyRepeatedFailure;
    private boolean includeTestSummary;
    private boolean includeFailedTests;
    private boolean uploadFiles;
    private String artifactIncludes;
    private MatrixTriggerMode matrixTriggerMode;
    private CommitInfoChoice commitInfoChoice;
    private boolean includeCustomMessage;
    private String customMessage;
    private String customMessageSuccess;
    private String customMessageAborted;
    private String customMessageNotBuilt;
    private String customMessageUnstable;
    private String customMessageFailure;
    private SlackUserIdResolver slackUserIdResolver;
    private transient String authTokenCredentialId;

    public String getAuthTokenCredentialId() {
        return this.tokenCredentialId;
    }

    private Object readResolve() {
        if (this.authTokenCredentialId != null) {
            this.tokenCredentialId = this.authTokenCredentialId;
        }
        return this;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getTeamDomain() {
        return this.teamDomain;
    }

    @DataBoundSetter
    public void setTeamDomain(String teamDomain) {
        this.teamDomain = teamDomain;
    }

    public String getRoom() {
        return this.room;
    }

    @DataBoundSetter
    public void setRoom(String room) {
        this.room = room;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    @DataBoundSetter
    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getTokenCredentialId() {
        return this.tokenCredentialId;
    }

    @DataBoundSetter
    public void setTokenCredentialId(String tokenCredentialId) {
        this.tokenCredentialId = tokenCredentialId;
    }

    public boolean getBotUser() {
        return this.botUser;
    }

    @DataBoundSetter
    public void setBotUser(boolean botUser) {
        this.botUser = botUser;
    }

    public String getSendAs() {
        return this.sendAs;
    }

    @DataBoundSetter
    public void setSendAs(String sendAs) {
        this.sendAs = sendAs;
    }

    public boolean getSendAsText() {
        return this.sendAsText;
    }

    @DataBoundSetter
    public void setSendAsText(boolean sendAsText) {
        this.sendAsText = sendAsText;
    }

    public String getIconEmoji() {
        return this.iconEmoji;
    }

    @DataBoundSetter
    public void setIconEmoji(String iconEmoji) {
        this.iconEmoji = iconEmoji;
    }

    public String getUsername() {
        return this.username;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean getStartNotification() {
        return this.startNotification;
    }

    public boolean getNotifySuccess() {
        return this.notifySuccess;
    }

    public CommitInfoChoice getCommitInfoChoice() {
        return this.commitInfoChoice;
    }

    @CheckForNull
    public MatrixTriggerMode getMatrixTriggerMode() {
        return this.matrixTriggerMode;
    }

    public boolean getNotifyAborted() {
        return this.notifyAborted;
    }

    public boolean getNotifyFailure() {
        return this.notifyFailure;
    }

    public boolean getNotifyEveryFailure() {
        return this.notifyEveryFailure;
    }

    public boolean getNotifyNotBuilt() {
        return this.notifyNotBuilt;
    }

    public boolean getNotifyUnstable() {
        return this.notifyUnstable;
    }

    public boolean getNotifyRegression() {
        return this.notifyRegression;
    }

    public boolean getNotifyBackToNormal() {
        return this.notifyBackToNormal;
    }

    public boolean getIncludeTestSummary() {
        return this.includeTestSummary;
    }

    public boolean getIncludeFailedTests() {
        return this.includeFailedTests;
    }

    public boolean getUploadFiles() {
        return this.uploadFiles;
    }

    public String getArtifactIncludes() {
        return this.artifactIncludes;
    }

    public boolean getNotifyRepeatedFailure() {
        return this.notifyRepeatedFailure;
    }

    public boolean getIncludeCustomMessage() {
        return this.includeCustomMessage;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    public String getCustomMessageSuccess() {
        return this.customMessageSuccess;
    }

    public String getCustomMessageAborted() {
        return this.customMessageAborted;
    }

    public String getCustomMessageNotBuilt() {
        return this.customMessageNotBuilt;
    }

    public String getCustomMessageUnstable() {
        return this.customMessageUnstable;
    }

    public String getCustomMessageFailure() {
        return this.customMessageFailure;
    }

    public SlackUserIdResolver getSlackUserIdResolver() {
        return this.slackUserIdResolver;
    }

    @DataBoundSetter
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @DataBoundSetter
    public void setStartNotification(boolean startNotification) {
        this.startNotification = startNotification;
    }

    @DataBoundSetter
    public void setNotifySuccess(boolean notifySuccess) {
        this.notifySuccess = notifySuccess;
    }

    @DataBoundSetter
    public void setCommitInfoChoice(CommitInfoChoice commitInfoChoice) {
        this.commitInfoChoice = commitInfoChoice;
    }

    @DataBoundSetter
    public void setMatrixTriggerMode(MatrixTriggerMode matrixTriggerMode) {
        this.matrixTriggerMode = matrixTriggerMode;
    }

    @DataBoundSetter
    public void setNotifyAborted(boolean notifyAborted) {
        this.notifyAborted = notifyAborted;
    }

    @DataBoundSetter
    public void setNotifyFailure(boolean notifyFailure) {
        this.notifyFailure = notifyFailure;
    }

    @DataBoundSetter
    public void setNotifyEveryFailure(boolean notifyEveryFailure) {
        this.notifyEveryFailure = notifyEveryFailure;
    }

    @DataBoundSetter
    public void setNotifyNotBuilt(boolean notifyNotBuilt) {
        this.notifyNotBuilt = notifyNotBuilt;
    }

    @DataBoundSetter
    public void setNotifyUnstable(boolean notifyUnstable) {
        this.notifyUnstable = notifyUnstable;
    }

    @DataBoundSetter
    public void setNotifyRegression(boolean notifyRegression) {
        this.notifyRegression = notifyRegression;
    }

    @DataBoundSetter
    public void setNotifyBackToNormal(boolean notifyBackToNormal) {
        this.notifyBackToNormal = notifyBackToNormal;
    }

    @DataBoundSetter
    public void setIncludeTestSummary(boolean includeTestSummary) {
        this.includeTestSummary = includeTestSummary;
    }

    @DataBoundSetter
    public void setIncludeFailedTests(boolean includeFailedTests) {
        this.includeFailedTests = includeFailedTests;
    }

    @DataBoundSetter
    public void setUploadFiles(boolean uploadFiles) {
        this.uploadFiles = uploadFiles;
    }

    @DataBoundSetter
    public void setArtifactIncludes(String artifactIncludes) {
        this.artifactIncludes = artifactIncludes;
    }

    @DataBoundSetter
    public void setNotifyRepeatedFailure(boolean notifyRepeatedFailure) {
        this.notifyRepeatedFailure = notifyRepeatedFailure;
    }

    @DataBoundSetter
    public void setIncludeCustomMessage(boolean includeCustomMessage) {
        this.includeCustomMessage = includeCustomMessage;
    }

    @DataBoundSetter
    public void setCustomMessage(String customMessage) {
        this.customMessage = customMessage;
    }

    @DataBoundSetter
    public void setCustomMessageSuccess(String customMessageSuccess) {
        this.customMessageSuccess = customMessageSuccess;
    }

    @DataBoundSetter
    public void setCustomMessageAborted(String customMessageAborted) {
        this.customMessageAborted = customMessageAborted;
    }

    @DataBoundSetter
    public void setCustomMessageNotBuilt(String customMessageNotBuilt) {
        this.customMessageNotBuilt = customMessageNotBuilt;
    }

    @DataBoundSetter
    public void setCustomMessageUnstable(String customMessageUnstable) {
        this.customMessageUnstable = customMessageUnstable;
    }

    @DataBoundSetter
    public void setCustomMessageFailure(String customMessageFailure) {
        this.customMessageFailure = customMessageFailure;
    }

    @DataBoundSetter
    public void setSlackUserIdResolver(SlackUserIdResolver slackUserIdResolver) {
        this.slackUserIdResolver = slackUserIdResolver;
    }

    @DataBoundConstructor
    public SlackNotifier(CommitInfoChoice commitInfoChoice) {
        this.commitInfoChoice = commitInfoChoice;
    }

    @Deprecated
    public SlackNotifier(String baseUrl, String teamDomain, String authToken, boolean botUser, String room, String tokenCredentialId, String sendAs, boolean startNotification, boolean notifyAborted, boolean notifyFailure, boolean notifyNotBuilt, boolean notifySuccess, boolean notifyUnstable, boolean notifyRegression, boolean notifyBackToNormal, boolean notifyRepeatedFailure, boolean includeTestSummary, boolean includeFailedTests, CommitInfoChoice commitInfoChoice, boolean includeCustomMessage, String customMessage) {
        this(baseUrl, teamDomain, authToken, botUser, room, tokenCredentialId, sendAs, startNotification, notifyAborted, notifyFailure, notifyNotBuilt, notifySuccess, notifyUnstable, notifyRegression, notifyBackToNormal, notifyRepeatedFailure, includeTestSummary, includeFailedTests, commitInfoChoice, includeCustomMessage, customMessage, null, null, null, null, null);
    }

    @Deprecated
    public SlackNotifier(String baseUrl, String teamDomain, String authToken, boolean botUser, String room, String tokenCredentialId, String sendAs, boolean startNotification, boolean notifyAborted, boolean notifyFailure, boolean notifyNotBuilt, boolean notifySuccess, boolean notifyUnstable, boolean notifyRegression, boolean notifyBackToNormal, boolean notifyRepeatedFailure, boolean includeTestSummary, boolean includeFailedTests, CommitInfoChoice commitInfoChoice, boolean includeCustomMessage, String customMessage, String customMessageSuccess, String customMessageAborted, String customMessageNotBuilt, String customMessageUnstable, String customMessageFailure) {
        this(baseUrl, teamDomain, authToken, botUser, room, tokenCredentialId, sendAs, startNotification, notifyAborted, notifyFailure, notifyNotBuilt, notifySuccess, notifyUnstable, notifyRegression, notifyBackToNormal, notifyRepeatedFailure, includeTestSummary, includeFailedTests, MatrixTriggerMode.ONLY_CONFIGURATIONS, commitInfoChoice, includeCustomMessage, customMessage, customMessageSuccess, customMessageAborted, customMessageNotBuilt, customMessageUnstable, customMessageFailure);
    }

    @Deprecated
    public SlackNotifier(String baseUrl, String teamDomain, String authToken, boolean botUser, String room, String tokenCredentialId, String sendAs, boolean startNotification, boolean notifyAborted, boolean notifyFailure, boolean notifyNotBuilt, boolean notifySuccess, boolean notifyUnstable, boolean notifyRegression, boolean notifyBackToNormal, boolean notifyRepeatedFailure, boolean includeTestSummary, boolean includeFailedTests, MatrixTriggerMode matrixTriggerMode, CommitInfoChoice commitInfoChoice, boolean includeCustomMessage, String customMessage, String customMessageSuccess, String customMessageAborted, String customMessageNotBuilt, String customMessageUnstable, String customMessageFailure) {
        this(new SlackNotifierBuilder().withBaseUrl(baseUrl).withTeamDomain(teamDomain).withAuthToken(authToken).withBotUser(botUser).withRoom(room).withTokenCredentialId(tokenCredentialId).withSendAs(sendAs).withStartNotification(startNotification).withNotifyAborted(notifyAborted).withNotifyFailure(notifyFailure).withNotifyNotBuilt(notifyNotBuilt).withNotifySuccess(notifySuccess).withNotifyUnstable(notifyUnstable).withNotifyRegression(notifyRegression).withNotifyBackToNormal(notifyBackToNormal).withNotifyRepeatedFailure(notifyRepeatedFailure).withIncludeTestSummary(includeTestSummary).withIncludeFailedTests(includeFailedTests).withMatrixTriggerMode(matrixTriggerMode).withCommitInfoChoice(commitInfoChoice).withIncludeCustomMessage(includeCustomMessage).withCustomMessage(customMessage).withCustomMessageSuccess(customMessageSuccess).withCustomMessageAborted(customMessageAborted).withCustomMessageNotBuilt(customMessageNotBuilt).withCustomMessageUnstable(customMessageUnstable).withCustomMessageFailure(customMessageFailure));
    }

    SlackNotifier(SlackNotifierBuilder slackNotifierBuilder) {
        this.baseUrl = slackNotifierBuilder.baseUrl;
        if (this.baseUrl != null && !this.baseUrl.isEmpty() && !this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
        this.teamDomain = slackNotifierBuilder.teamDomain;
        this.authToken = slackNotifierBuilder.authToken;
        this.tokenCredentialId = slackNotifierBuilder.tokenCredentialId;
        this.botUser = slackNotifierBuilder.botUser;
        this.room = slackNotifierBuilder.room;
        this.sendAs = slackNotifierBuilder.sendAs;
        this.iconEmoji = slackNotifierBuilder.iconEmoji;
        this.username = slackNotifierBuilder.username;
        this.startNotification = slackNotifierBuilder.startNotification;
        this.notifySuccess = slackNotifierBuilder.notifySuccess;
        this.notifyAborted = slackNotifierBuilder.notifyAborted;
        this.notifyNotBuilt = slackNotifierBuilder.notifyNotBuilt;
        this.notifyUnstable = slackNotifierBuilder.notifyUnstable;
        this.notifyRegression = slackNotifierBuilder.notifyRegression;
        this.notifyFailure = slackNotifierBuilder.notifyFailure;
        this.notifyEveryFailure = slackNotifierBuilder.notifyEveryFailure;
        this.notifyBackToNormal = slackNotifierBuilder.notifyBackToNormal;
        this.notifyRepeatedFailure = slackNotifierBuilder.notifyRepeatedFailure;
        this.includeTestSummary = slackNotifierBuilder.includeTestSummary;
        this.includeFailedTests = slackNotifierBuilder.includeFailedTests;
        this.uploadFiles = slackNotifierBuilder.uploadFiles;
        this.artifactIncludes = slackNotifierBuilder.artifactIncludes;
        this.matrixTriggerMode = slackNotifierBuilder.matrixTriggerMode;
        this.commitInfoChoice = slackNotifierBuilder.commitInfoChoice;
        this.includeCustomMessage = slackNotifierBuilder.includeCustomMessage;
        if (this.includeCustomMessage) {
            this.customMessage = slackNotifierBuilder.customMessage;
            this.customMessageSuccess = slackNotifierBuilder.customMessageSuccess;
            this.customMessageAborted = slackNotifierBuilder.customMessageAborted;
            this.customMessageNotBuilt = slackNotifierBuilder.customMessageNotBuilt;
            this.customMessageUnstable = slackNotifierBuilder.customMessageUnstable;
            this.customMessageFailure = slackNotifierBuilder.customMessageFailure;
        } else {
            this.customMessage = null;
        }
        this.slackUserIdResolver = slackNotifierBuilder.slackUserIdResolver;
    }

    public static SlackNotifierBuilder builder() {
        return new SlackNotifierBuilder();
    }

    public boolean isAnyCustomMessagePopulated() {
        return Stream.of(this.customMessage, this.customMessageSuccess, this.customMessageAborted, this.customMessageNotBuilt, this.customMessageUnstable, this.customMessageFailure).anyMatch(StringUtils::isNotEmpty);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public SlackService newSlackService(AbstractBuild abstractBuild, BuildListener listener) {
        EnvVars env;
        DescriptorImpl descriptor = this.getDescriptor();
        String teamDomain = Util.fixEmpty((String)this.teamDomain) != null ? this.teamDomain : descriptor.getTeamDomain();
        String baseUrl = Util.fixEmpty((String)this.baseUrl) != null ? this.baseUrl : descriptor.getBaseUrl();
        String authToken = Util.fixEmpty((String)this.authToken);
        boolean botUser = this.botUser || descriptor.isBotUser();
        String authTokenCredentialId = Util.fixEmpty((String)this.tokenCredentialId) != null ? this.tokenCredentialId : descriptor.getTokenCredentialId();
        String room = Util.fixEmpty((String)this.room) != null ? this.room : descriptor.getRoom();
        String iconEmoji = Util.fixEmpty((String)this.iconEmoji) != null ? this.iconEmoji : descriptor.getIconEmoji();
        String username = Util.fixEmpty((String)this.username) != null ? this.username : descriptor.getUsername();
        SlackUserIdResolver slackUserIdResolver = this.slackUserIdResolver != null ? this.slackUserIdResolver : descriptor.getSlackUserIdResolver();
        try {
            env = abstractBuild.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            listener.getLogger().println("Error retrieving environment vars: " + e.getMessage());
            env = new EnvVars();
        }
        baseUrl = env.expand(baseUrl);
        teamDomain = env.expand(teamDomain);
        authToken = env.expand(authToken);
        authTokenCredentialId = env.expand(authTokenCredentialId);
        room = env.expand(room);
        String populatedToken = CredentialsObtainer.getTokenToUse(authTokenCredentialId, (Item)abstractBuild.getParent(), authToken);
        return new StandardSlackService(new StandardSlackServiceBuilder().withBaseUrl(baseUrl).withTeamDomain(teamDomain).withBotUser(botUser).withRoomId(room).withIconEmoji(iconEmoji).withUsername(username).withPopulatedToken(populatedToken).withSlackUserIdResolver(slackUserIdResolver));
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        String buildKey = BuildKey.format(build);
        BuildAwareLogger log = SlackNotifier.createLogger(listener);
        log.debug(buildKey, "Performing complete notifications", new Object[0]);
        JenkinsTokenExpander tokenExpander = new JenkinsTokenExpander((TaskListener)listener);
        new ActiveNotifier(this, this.slackFactory(listener), log, tokenExpander).completed(build);
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        String buildKey = BuildKey.format(build);
        BuildAwareLogger log = SlackNotifier.createLogger(listener);
        if (this.startNotification) {
            log.debug(buildKey, "Performing start notifications", new Object[0]);
            new ActiveNotifier(this, this.slackFactory(listener), log, new JenkinsTokenExpander((TaskListener)listener)).started(build);
        }
        return super.prebuild(build, listener);
    }

    private Function<AbstractBuild<?, ?>, SlackService> slackFactory(BuildListener listener) {
        return b -> this.newSlackService((AbstractBuild)b, listener);
    }

    private static BuildAwareLogger createLogger(BuildListener listener) {
        return new SlackNotificationsLogger(logger, (TaskListener)listener);
    }

    public boolean isMatrixRun(AbstractBuild<?, ?> build) {
        return build.getClass().getName().equals(MATRIX_RUN_CLASS_NAME);
    }

    @Extension
    @Symbol(value={"slackNotifier"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final String PLUGIN_DISPLAY_NAME = "Slack Notifications";
        private String baseUrl;
        private String teamDomain;
        private String token;
        private String tokenCredentialId;
        private boolean botUser;
        private boolean sendAsText;
        private String iconEmoji;
        private String username;
        private String room;
        private String sendAs;
        private SlackUserIdResolver slackUserIdResolver;

        public DescriptorImpl() {
            this.load();
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        @DataBoundSetter
        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public String getTeamDomain() {
            return this.teamDomain;
        }

        @DataBoundSetter
        public void setTeamDomain(String teamDomain) {
            this.teamDomain = teamDomain;
        }

        @Deprecated
        public String getToken() {
            return this.token;
        }

        @Deprecated
        @DataBoundSetter
        public void setToken(String token) {
            this.token = token;
        }

        public String getTokenCredentialId() {
            return this.tokenCredentialId;
        }

        @DataBoundSetter
        public void setTokenCredentialId(String tokenCredentialId) {
            this.tokenCredentialId = tokenCredentialId;
        }

        public boolean isBotUser() {
            return this.botUser;
        }

        @Deprecated
        public boolean getBotUser() {
            return this.botUser;
        }

        @DataBoundSetter
        public void setBotUser(boolean botUser) {
            this.botUser = botUser;
        }

        public boolean isSendAsText() {
            return this.sendAsText;
        }

        @DataBoundSetter
        public void setSendAsText(boolean sendAsText) {
            this.sendAsText = sendAsText;
        }

        public String getIconEmoji() {
            return this.iconEmoji;
        }

        @DataBoundSetter
        public void setIconEmoji(String iconEmoji) {
            this.iconEmoji = iconEmoji;
        }

        public String getUsername() {
            return this.username;
        }

        @DataBoundSetter
        public void setUsername(String username) {
            this.username = username;
        }

        public String getRoom() {
            return this.room;
        }

        @DataBoundSetter
        public void setRoom(String room) {
            this.room = room;
        }

        public String getSendAs() {
            return this.sendAs;
        }

        @DataBoundSetter
        public void setSendAs(String sendAs) {
            this.sendAs = sendAs;
        }

        public SlackUserIdResolver getSlackUserIdResolver() {
            return this.slackUserIdResolver;
        }

        @DataBoundSetter
        public void setSlackUserIdResolver(SlackUserIdResolver slackUserIdResolver) {
            this.slackUserIdResolver = slackUserIdResolver;
        }

        public DescriptorExtensionList<SlackUserIdResolver, SlackUserIdResolverDescriptor> getSlackUserIdResolverDescriptors() {
            return SlackUserIdResolverDescriptor.all();
        }

        public ListBoxModel doFillCommitInfoChoiceItems() {
            ListBoxModel model = new ListBoxModel();
            for (CommitInfoChoice choice : CommitInfoChoice.values()) {
                model.add(choice.getDisplayName(), choice.name());
            }
            return model;
        }

        public FormValidation doCheckTeamDomain(@QueryParameter String value, @QueryParameter String baseUrl) {
            if (StringUtils.isNotBlank((CharSequence)value) && StringUtils.isNotBlank((CharSequence)baseUrl)) {
                return FormValidation.error((String)Messages.workspaceNameAndBaseUrlSet());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBaseUrl(@QueryParameter String value, @QueryParameter String teamDomain) {
            if (StringUtils.isNotBlank((CharSequence)value) && StringUtils.isNotBlank((CharSequence)teamDomain)) {
                return FormValidation.error((String)Messages.workspaceNameAndBaseUrlSet());
            }
            if (StringUtils.isNotBlank((CharSequence)value) && StandardSlackService.JENKINS_CI_HOOK_REGEX.matcher(value).matches()) {
                return FormValidation.error((String)Messages.baseUrlIsJenkinsCiAppUrl());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillTokenCredentialIdItems(@AncestorInPath Item context) {
            return DescriptorImpl.findTokenCredentialIdItems(context);
        }

        @Restricted(value={NoExternalUse.class})
        public static ListBoxModel findTokenCredentialIdItems(@AncestorInPath Item context) {
            Jenkins jenkins = Jenkins.get();
            if (context == null && !jenkins.hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, context, StringCredentials.class, Collections.singletonList(new HostnameRequirement("*.slack.com")));
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        @Deprecated
        SlackService getSlackService(String baseUrl, String teamDomain, String authTokenCredentialId, boolean botUser, String roomId) {
            return this.getSlackService(baseUrl, teamDomain, authTokenCredentialId, botUser, roomId, null);
        }

        @Deprecated
        SlackService getSlackService(String baseUrl, String teamDomain, String authTokenCredentialId, boolean botUser, String roomId, Item item) {
            String populatedToken = CredentialsObtainer.getTokenToUse(authTokenCredentialId, item, null);
            if (populatedToken != null) {
                return new StandardSlackService(StandardSlackService.builder().withBaseUrl(baseUrl).withTeamDomain(teamDomain).withBotUser(botUser).withRoomId(roomId).withPopulatedToken(populatedToken));
            }
            throw new NoSuchElementException("Could not obtain credentials with credential id: " + authTokenCredentialId);
        }

        SlackService getSlackService(StandardSlackServiceBuilder slackServiceBuilder, String authTokenCredentialsID, Item item) {
            String populatedToken = CredentialsObtainer.getTokenToUse(authTokenCredentialsID, item, null);
            if (populatedToken != null) {
                slackServiceBuilder.withPopulatedToken(populatedToken);
                return slackServiceBuilder.build();
            }
            throw new NoSuchElementException("Could not obtain credentials with credential id: " + slackServiceBuilder.populatedToken);
        }

        public boolean isMatrixProject(AbstractProject<?, ?> project) {
            return project.getClass().getName().equals(SlackNotifier.MATRIX_PROJECT_CLASS_NAME);
        }

        @NonNull
        public String getDisplayName() {
            return PLUGIN_DISPLAY_NAME;
        }

        @POST
        public FormValidation doClearCache() {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            logger.info("Clearing channel ID cache");
            SlackChannelIdCache.clearCache();
            return FormValidation.ok((String)"Cache cleared");
        }

        @POST
        public FormValidation doTestConnectionGlobal(@QueryParameter(value="baseUrl") String baseUrl, @QueryParameter(value="teamDomain") String teamDomain, @QueryParameter(value="tokenCredentialId") String tokenCredentialId, @QueryParameter(value="botUser") boolean botUser, @QueryParameter(value="room") String room, @QueryParameter(value="sendAsText") boolean sendAsText, @QueryParameter(value="iconEmoji") String iconEmoji, @QueryParameter(value="username") String username) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                Object targetUrl = baseUrl;
                if (targetUrl != null && !((String)targetUrl).isEmpty() && !((String)targetUrl).endsWith("/")) {
                    targetUrl = (String)targetUrl + "/";
                }
                SlackService testSlackService = this.getSlackService(StandardSlackService.builder().withBaseUrl((String)targetUrl).withTeamDomain(teamDomain).withBotUser(botUser).withRoomId(room).withIconEmoji(iconEmoji).withUsername(username), tokenCredentialId, null);
                return this.validateConnection(sendAsText, testSlackService);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Slack config form validation error", e);
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        private FormValidation validateConnection(boolean sendAsText, SlackService testSlackService) {
            String message = "Slack/Jenkins plugin: you're all set on " + DisplayURLProvider.get().getRoot();
            boolean success = sendAsText ? testSlackService.publish(message, new JSONArray(), "") : testSlackService.publish(message, "good");
            return success ? FormValidation.ok((String)"Success") : FormValidation.error((String)this.getErrorMessage(testSlackService.getResponseString()));
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="baseUrl") String baseUrl, @QueryParameter(value="teamDomain") String teamDomain, @QueryParameter(value="tokenCredentialId") String tokenCredentialId, @QueryParameter(value="botUser") boolean botUser, @QueryParameter(value="room") String room, @QueryParameter(value="sendAsText") boolean sendAsText, @QueryParameter(value="iconEmoji") String iconEmoji, @QueryParameter(value="username") String username, @AncestorInPath Project project) {
            if (project == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                project.checkPermission(Item.CONFIGURE);
            }
            try {
                Object targetUrl = baseUrl;
                if (targetUrl != null && !((String)targetUrl).isEmpty() && !((String)targetUrl).endsWith("/")) {
                    targetUrl = (String)targetUrl + "/";
                }
                if (StringUtils.isEmpty((CharSequence)targetUrl)) {
                    targetUrl = this.baseUrl;
                }
                String targetDomain = Util.fixEmpty((String)teamDomain) != null ? teamDomain : this.teamDomain;
                String targetRoom = Util.fixEmpty((String)room) != null ? room : this.room;
                boolean targetBotUser = botUser || this.botUser;
                String targetTokenCredentialId = Util.fixEmpty((String)tokenCredentialId) != null ? tokenCredentialId : this.tokenCredentialId;
                boolean targetSendAsText = sendAsText || this.sendAsText;
                String targetIconEmoji = Util.fixEmpty((String)iconEmoji) != null ? iconEmoji : this.iconEmoji;
                String targetUsername = Util.fixEmpty((String)username) != null ? username : this.username;
                SlackService testSlackService = this.getSlackService(StandardSlackService.builder().withBaseUrl((String)targetUrl).withTeamDomain(targetDomain).withBotUser(targetBotUser).withRoomId(targetRoom).withIconEmoji(targetIconEmoji).withUsername(targetUsername), targetTokenCredentialId, (Item)project);
                return this.validateConnection(targetSendAsText, testSlackService);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Slack config form validation error", e);
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        private String getErrorMessage(String responseString) {
            String error = "Failure";
            if (responseString != null) {
                return String.format("%s: %s", error, responseString);
            }
            return error;
        }

        private Object readResolve() {
            if (Util.fixEmpty((String)this.token) != null) {
                this.tokenCredentialId = new GlobalCredentialMigrator().migrate(this.token).getId();
                this.token = null;
                this.save();
            }
            return this;
        }
    }
}

