/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.pipeline;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.CredentialsObtainer;
import jenkins.plugins.slack.HttpClient;
import jenkins.plugins.slack.Messages;
import jenkins.plugins.slack.SlackNotifier;
import jenkins.plugins.slack.user.SlackUserIdResolver;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SlackUserIdsFromCommittersStep
extends Step {
    private static final Logger logger = Logger.getLogger(SlackUserIdsFromCommittersStep.class.getName());
    private String tokenCredentialId;
    private boolean botUser;

    @DataBoundConstructor
    public SlackUserIdsFromCommittersStep() {
    }

    public String getTokenCredentialId() {
        return this.tokenCredentialId;
    }

    @DataBoundSetter
    public void setTokenCredentialId(String tokenCredentialId) {
        this.tokenCredentialId = Util.fixEmpty((String)tokenCredentialId);
    }

    public boolean getBotUser() {
        return this.botUser;
    }

    @DataBoundSetter
    public void setBotUser(boolean botUser) {
        this.botUser = botUser;
    }

    public StepExecution start(StepContext context) {
        return new SlackUserIdsFromCommittersStepExcecution(this, context);
    }

    public static class SlackUserIdsFromCommittersStepExcecution
    extends SynchronousNonBlockingStepExecution<List<String>> {
        private static final long serialVersionUID = 1L;
        private final transient SlackUserIdsFromCommittersStep step;

        SlackUserIdsFromCommittersStepExcecution(SlackUserIdsFromCommittersStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected List<String> run() throws Exception {
            String populatedToken;
            Jenkins jenkins = Jenkins.get();
            Item item = CredentialsObtainer.getItemForCredentials(this.getContext());
            SlackNotifier.DescriptorImpl slackDesc = (SlackNotifier.DescriptorImpl)jenkins.getDescriptorByType(SlackNotifier.DescriptorImpl.class);
            String tokenCredentialId = this.step.tokenCredentialId != null ? this.step.tokenCredentialId : slackDesc.getTokenCredentialId();
            boolean botUser = this.step.botUser || slackDesc.isBotUser();
            SlackUserIdResolver userIdResolver = slackDesc.getSlackUserIdResolver();
            Run run = (Run)this.getContext().get(Run.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            Objects.requireNonNull(listener, "Listener is mandatory here");
            if (!botUser) {
                listener.getLogger().println("The slackUserIdsFromCommitters step requires bot user mode");
                return null;
            }
            try {
                populatedToken = CredentialsObtainer.getTokenToUse(tokenCredentialId, item, null);
            }
            catch (IllegalArgumentException e) {
                listener.error(Messages.notificationFailedWithException(e));
                return null;
            }
            ArrayList<String> slackUserIds = new ArrayList<String>();
            try (CloseableHttpClient client = this.getHttpClient();){
                if (userIdResolver != null && run != null) {
                    userIdResolver.setAuthToken(populatedToken);
                    userIdResolver.setHttpClient(client);
                    List<String> userIds = userIdResolver.resolveUserIdsForRun(run);
                    slackUserIds.addAll(userIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()));
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error closing HttpClient", e);
            }
            return slackUserIds;
        }

        protected CloseableHttpClient getHttpClient() {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            ProxyConfiguration proxy = jenkins != null ? jenkins.proxy : null;
            return HttpClient.getCloseableHttpClient(proxy);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "slackUserIdsFromCommitters";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.slackUserIdsFromCommittersDisplayName();
        }

        public ListBoxModel doFillTokenCredentialIdItems(@AncestorInPath Item item) {
            return SlackNotifier.DescriptorImpl.findTokenCredentialIdItems(item);
        }
    }
}

