/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Project;
import hudson.model.Run;
import hudson.security.ACL;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class CredentialsObtainer {
    private static final Logger logger = Logger.getLogger(CredentialsObtainer.class.getName());

    public static StringCredentials lookupCredentials(String credentialId) {
        List credentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        return CredentialsObtainer.getCredentialWithId(credentialId, credentials);
    }

    public static StringCredentials lookupCredentials(String credentialId, Item item) {
        List credentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList());
        return CredentialsObtainer.getCredentialWithId(credentialId, credentials);
    }

    public static String getTokenToUse(String credentialId, Item item, String token) {
        StringCredentials credentials;
        String response = StringUtils.isEmpty((CharSequence)credentialId) ? token : ((credentials = CredentialsObtainer.lookupCredentials(StringUtils.trim((String)credentialId), item)) != null ? credentials.getSecret().getPlainText() : token);
        if (StringUtils.isEmpty((CharSequence)response)) {
            throw new IllegalArgumentException(String.format("the credential with the provided ID (%s) could not be found and no token was specified", credentialId));
        }
        return response;
    }

    @Restricted(value={NoExternalUse.class})
    public static Item getItemForCredentials(StepContext context) {
        Item item = null;
        try {
            Run run;
            item = (Item)context.get(Project.class);
            if (item == null && (run = (Run)context.get(Run.class)) != null) {
                item = run.getParent();
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception obtaining item for credentials lookup. Only global credentials will be available", e);
        }
        return item;
    }

    private static StringCredentials getCredentialWithId(String credentialId, List<StringCredentials> credentials) {
        CredentialsMatcher matcher = CredentialsMatchers.withId((String)credentialId);
        return (StringCredentials)CredentialsMatchers.firstOrNull(credentials, (CredentialsMatcher)matcher);
    }
}

