/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import hudson.triggers.SCMTrigger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.CommitInfoChoice;
import jenkins.plugins.slack.FineGrainedNotifier;
import jenkins.plugins.slack.SlackNotifier;
import jenkins.plugins.slack.SlackService;
import jenkins.plugins.slack.TokenExpander;
import jenkins.plugins.slack.decisions.Context;
import jenkins.plugins.slack.decisions.NotificationConditions;
import jenkins.plugins.slack.logging.BuildAwareLogger;
import jenkins.plugins.slack.logging.BuildKey;
import jenkins.plugins.slack.matrix.MatrixTriggerMode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public class ActiveNotifier
implements FineGrainedNotifier {
    SlackNotifier notifier;
    private final Function<AbstractBuild<?, ?>, SlackService> slackFactory;
    private final BuildAwareLogger log;
    private final TokenExpander tokenExpander;

    public ActiveNotifier(SlackNotifier notifier, Function<AbstractBuild<?, ?>, SlackService> slackFactory, BuildAwareLogger log, TokenExpander tokenExpander) {
        this.notifier = notifier;
        this.slackFactory = slackFactory;
        this.log = log;
        this.tokenExpander = tokenExpander;
    }

    @Override
    public void deleted(AbstractBuild r) {
    }

    @Override
    public void started(AbstractBuild build) {
        if (this.skipOnMatrixChildren(build)) {
            return;
        }
        String key = BuildKey.format(build);
        CauseAction causeAction = (CauseAction)build.getAction(CauseAction.class);
        if (causeAction != null) {
            Cause scmCause = causeAction.findCause(SCMTrigger.SCMTriggerCause.class);
            if (scmCause == null) {
                this.log.debug(key, "was not caused by SCM Trigger", new Object[0]);
                MessageBuilder message = new MessageBuilder(this.notifier, build, this.log, this.tokenExpander);
                message.append(((Cause)causeAction.getCauses().get(0)).getShortDescription());
                message.appendOpenLink();
                if (this.notifier.getIncludeCustomMessage()) {
                    message.appendCustomMessage(build.getResult());
                }
                this.notifyStart(build, message.toString());
                return;
            }
        } else {
            this.log.debug(key, "did not have a cause action", new Object[0]);
        }
        String changes = this.getChanges(build, this.notifier.getIncludeCustomMessage());
        if (changes != null) {
            this.notifyStart(build, changes);
        } else {
            this.notifyStart(build, this.getBuildStatusMessage(build, false, false, this.notifier.getIncludeCustomMessage()));
        }
    }

    private void notifyStart(AbstractBuild build, String message) {
        AbstractProject project = build.getProject();
        AbstractBuild lastBuild = project.getLastBuild();
        SlackService slack = this.slackFactory.apply(build);
        if (lastBuild != null) {
            AbstractBuild previousBuild = (AbstractBuild)lastBuild.getPreviousCompletedBuild();
            if (previousBuild == null) {
                slack.publish(message, "good");
            } else {
                slack.publish(message, ActiveNotifier.getBuildColor(previousBuild));
            }
        } else {
            slack.publish(message, "good");
        }
    }

    @Override
    public void finalized(AbstractBuild r) {
    }

    @Override
    public void completed(AbstractBuild r) {
        if (this.skipOnMatrixChildren(r)) {
            return;
        }
        String key = BuildKey.format(r);
        AbstractProject project = r.getProject();
        AbstractBuild previousBuild = project.getLastBuild();
        if (null != previousBuild) {
            while (null != (previousBuild = (AbstractBuild)previousBuild.getPreviousCompletedBuild()) && previousBuild.getResult() == Result.ABORTED || null != previousBuild && previousBuild.getNumber() == r.getNumber()) {
            }
            if (null != previousBuild) {
                this.log.info(key, "found #%d as previous completed, non-aborted build", previousBuild.getNumber());
            } else {
                this.log.debug(key, "did not find previous completed, non-aborted build", new Object[0]);
            }
            NotificationConditions conditions = NotificationConditions.create(this.notifier, this.log);
            if (conditions.test(new Context(r, previousBuild))) {
                Object message = this.getBuildStatusMessage(r, this.notifier.getIncludeTestSummary(), this.notifier.getIncludeFailedTests(), this.notifier.getIncludeCustomMessage());
                if (this.notifier.getCommitInfoChoice().showAnything()) {
                    message = (String)message + "\n" + this.getCommitList(r);
                }
                this.slackFactory.apply(r).publish((String)message, ActiveNotifier.getBuildColor(r));
                if (this.notifier.getUploadFiles()) {
                    this.slackFactory.apply(r).upload(r.getWorkspace(), this.notifier.getArtifactIncludes(), this.log.getTaskListener());
                }
            }
        }
    }

    private boolean skipOnMatrixChildren(AbstractBuild build) {
        if (this.notifier.isMatrixRun(build)) {
            MatrixTriggerMode matrixTriggerMode = this.notifier.getMatrixTriggerMode();
            return matrixTriggerMode == null || !matrixTriggerMode.forChild;
        }
        return false;
    }

    String getChanges(AbstractBuild r, boolean includeCustomMessage) {
        String key = BuildKey.format(r);
        if (!r.hasChangeSetComputed()) {
            this.log.debug(key, "did not have change set computed", new Object[0]);
            return null;
        }
        ChangeLogSet changeSet = r.getChangeSet();
        LinkedList<ChangeLogSet.Entry> entries = new LinkedList<ChangeLogSet.Entry>();
        HashSet files = new HashSet();
        for (Object o : changeSet.getItems()) {
            ChangeLogSet.Entry entry = (ChangeLogSet.Entry)o;
            this.log.debug(key, "adding changeset entry: %s", o);
            entries.add(entry);
            if (!CollectionUtils.isNotEmpty((Collection)entry.getAffectedFiles())) continue;
            files.addAll(entry.getAffectedFiles());
        }
        if (entries.isEmpty()) {
            this.log.debug(key, "did not have entries in changeset", new Object[0]);
            return null;
        }
        HashSet<String> authors = new HashSet<String>();
        for (ChangeLogSet.Entry entry : entries) {
            authors.add(entry.getAuthor().getDisplayName());
        }
        MessageBuilder message = new MessageBuilder(this.notifier, r, this.log, this.tokenExpander);
        message.append("Started by changes from ");
        message.append(StringUtils.join(authors, (String)", "));
        message.append(" (");
        message.append(files.size());
        message.append(" file(s) changed)");
        message.appendOpenLink();
        if (includeCustomMessage) {
            message.appendCustomMessage(r.getResult());
        }
        return message.toString();
    }

    String getCommitList(AbstractBuild r) {
        String buildKey = BuildKey.format(r);
        ChangeLogSet changeSet = r.getChangeSet();
        LinkedList<ChangeLogSet.Entry> entries = new LinkedList<ChangeLogSet.Entry>();
        for (Object o : changeSet.getItems()) {
            ChangeLogSet.Entry entry = (ChangeLogSet.Entry)o;
            this.log.debug(buildKey, "adding changeset entry: %s", o);
            entries.add(entry);
        }
        if (entries.isEmpty()) {
            this.log.debug(buildKey, "did not have entries in changeset", new Object[0]);
            Cause.UpstreamCause c = (Cause.UpstreamCause)r.getCause(Cause.UpstreamCause.class);
            if (c == null) {
                return "No Changes.";
            }
            String upProjectName = c.getUpstreamProject();
            int buildNumber = c.getUpstreamBuild();
            AbstractProject project = (AbstractProject)Jenkins.get().getItemByFullName(upProjectName, AbstractProject.class);
            if (project != null) {
                AbstractBuild upBuild = project.getBuildByNumber(buildNumber);
                return this.getCommitList(upBuild);
            }
        }
        HashSet<String> commits = new HashSet<String>();
        for (ChangeLogSet.Entry entry : entries) {
            StringBuilder commit = new StringBuilder();
            CommitInfoChoice commitInfoChoice = this.notifier.getCommitInfoChoice();
            if (commitInfoChoice.showTitle()) {
                commit.append(entry.getMsg());
            }
            if (commitInfoChoice.showAuthor()) {
                commit.append(" [").append(entry.getAuthor().getDisplayName()).append("]");
            }
            commits.add(commit.toString());
        }
        MessageBuilder message = new MessageBuilder(this.notifier, r, this.log, this.tokenExpander);
        message.append("Changes:\n- ");
        message.append(StringUtils.join(commits, (String)"\n- "));
        return message.toString();
    }

    static String getBuildColor(AbstractBuild r) {
        Result result = r.getResult();
        if (result == Result.SUCCESS) {
            return "good";
        }
        if (result == Result.FAILURE) {
            return "danger";
        }
        return "warning";
    }

    String getBuildStatusMessage(AbstractBuild r, boolean includeTestSummary, boolean includeFailedTests, boolean includeCustomMessage) {
        MessageBuilder message = new MessageBuilder(this.notifier, r, this.log, this.tokenExpander);
        message.appendStatusMessage();
        message.appendDuration();
        message.appendOpenLink();
        if (includeTestSummary) {
            message.appendTestSummary();
        }
        if (includeFailedTests) {
            message.appendFailedTests();
        }
        if (includeCustomMessage) {
            message.appendCustomMessage(r.getResult());
        }
        return message.toString();
    }

    public static class MessageBuilder {
        private static final Pattern aTag = Pattern.compile("(?i)<a([^>]+)>(.+?)</a>|([{%])");
        private static final Pattern href = Pattern.compile("\\s*(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))");
        private static final String BACK_TO_NORMAL_STATUS_MESSAGE = "Back to normal";
        private static final String STILL_FAILING_STATUS_MESSAGE = "Still Failing";
        private static final String SUCCESS_STATUS_MESSAGE = "Success";
        private static final String FAILURE_STATUS_MESSAGE = "Failure";
        private static final String ABORTED_STATUS_MESSAGE = "Aborted";
        private static final String NOT_BUILT_STATUS_MESSAGE = "Not built";
        private static final String UNSTABLE_STATUS_MESSAGE = "Unstable";
        private static final String REGRESSION_STATUS_MESSAGE = "Regression";
        private static final String UNKNOWN_STATUS_MESSAGE = "Unknown";
        private StringBuilder message;
        private SlackNotifier notifier;
        private final BuildAwareLogger log;
        private final String buildKey;
        private final TokenExpander tokenExpander;
        private AbstractBuild build;

        public MessageBuilder(SlackNotifier notifier, AbstractBuild build, BuildAwareLogger log, TokenExpander tokenExpander) {
            this.notifier = notifier;
            this.log = log;
            this.tokenExpander = tokenExpander;
            this.message = new StringBuilder();
            this.build = build;
            this.buildKey = BuildKey.format(build);
            this.startMessage();
        }

        public MessageBuilder appendStatusMessage() {
            this.message.append(this.escape(this.getStatusMessage(this.build)));
            return this;
        }

        private String getStatusMessage(AbstractBuild r) {
            AbstractBuild lastBuild;
            Result result = r.getResult();
            if (null != result && (lastBuild = r.getProject().getLastBuild()) != null) {
                AbstractBuild lastNonAbortedBuild;
                AbstractBuild previousBuild = lastBuild.getPreviousBuild();
                Run previousSuccessfulBuild = r.getPreviousSuccessfulBuild();
                boolean buildHasSucceededBefore = previousSuccessfulBuild != null;
                for (lastNonAbortedBuild = previousBuild; lastNonAbortedBuild != null && lastNonAbortedBuild.getResult() == Result.ABORTED; lastNonAbortedBuild = lastNonAbortedBuild.getPreviousBuild()) {
                }
                Result previousResult = lastNonAbortedBuild == null ? Result.SUCCESS : lastNonAbortedBuild.getResult();
                if (result == Result.SUCCESS && (previousResult == Result.FAILURE || previousResult == Result.UNSTABLE) && buildHasSucceededBefore && this.notifier.getNotifyBackToNormal()) {
                    return BACK_TO_NORMAL_STATUS_MESSAGE;
                }
                if (result == Result.FAILURE && previousResult == Result.FAILURE) {
                    return STILL_FAILING_STATUS_MESSAGE;
                }
                if (result == Result.SUCCESS) {
                    return SUCCESS_STATUS_MESSAGE;
                }
                if (result == Result.FAILURE) {
                    return FAILURE_STATUS_MESSAGE;
                }
                if (result == Result.ABORTED) {
                    return ABORTED_STATUS_MESSAGE;
                }
                if (result == Result.NOT_BUILT) {
                    return NOT_BUILT_STATUS_MESSAGE;
                }
                if (result == Result.UNSTABLE) {
                    return UNSTABLE_STATUS_MESSAGE;
                }
                if (lastNonAbortedBuild != null && previousResult != null && result.isWorseThan(previousResult)) {
                    return REGRESSION_STATUS_MESSAGE;
                }
            }
            return UNKNOWN_STATUS_MESSAGE;
        }

        public MessageBuilder append(String string) {
            this.message.append(this.escape(string));
            return this;
        }

        public MessageBuilder append(Object string) {
            this.message.append(this.escape(string.toString()));
            return this;
        }

        private MessageBuilder startMessage() {
            this.message.append(this.escape(this.build.getProject().getFullDisplayName()));
            this.message.append(" - ");
            this.message.append(this.escape(this.build.getDisplayName()));
            this.message.append(" ");
            return this;
        }

        public MessageBuilder appendOpenLink() {
            String url = DisplayURLProvider.get().getRunURL((Run)this.build);
            this.message.append(" (<").append(url).append("|Open>)");
            return this;
        }

        public MessageBuilder appendDuration() {
            this.message.append(" after ");
            String durationString = this.message.toString().contains(BACK_TO_NORMAL_STATUS_MESSAGE) ? this.createBackToNormalDurationString() : this.build.getDurationString();
            this.message.append(durationString);
            return this;
        }

        public MessageBuilder appendTestSummary() {
            AbstractTestResultAction action = (AbstractTestResultAction)this.build.getAction(AbstractTestResultAction.class);
            if (action != null) {
                int total = action.getTotalCount();
                int failed = action.getFailCount();
                int skipped = action.getSkipCount();
                this.message.append("\nTest Status:\n");
                this.message.append("\tPassed: ").append(total - failed - skipped);
                this.message.append(", Failed: ").append(failed);
                this.message.append(", Skipped: ").append(skipped);
            } else {
                this.message.append("\nNo Tests found.");
            }
            return this;
        }

        public MessageBuilder appendFailedTests() {
            int failed;
            AbstractTestResultAction action = (AbstractTestResultAction)this.build.getAction(AbstractTestResultAction.class);
            if (action != null && (failed = action.getFailCount()) > 0) {
                this.message.append("\n").append(failed).append(" Failed Tests:\n");
                for (TestResult result : action.getFailedTests()) {
                    this.message.append("\t").append(this.getTestClassAndMethod(result)).append(" after ").append(result.getDurationString()).append("\n");
                }
            }
            return this;
        }

        public MessageBuilder appendCustomMessage(Result buildResult) {
            String customMessage = "";
            if (buildResult != null) {
                if (buildResult == Result.SUCCESS) {
                    customMessage = this.notifier.getCustomMessageSuccess();
                } else if (buildResult == Result.ABORTED) {
                    customMessage = this.notifier.getCustomMessageAborted();
                } else if (buildResult == Result.NOT_BUILT) {
                    customMessage = this.notifier.getCustomMessageNotBuilt();
                } else if (buildResult == Result.UNSTABLE) {
                    customMessage = this.notifier.getCustomMessageUnstable();
                } else if (buildResult == Result.FAILURE) {
                    customMessage = this.notifier.getCustomMessageFailure();
                }
            }
            if (customMessage == null || customMessage.isEmpty()) {
                customMessage = this.notifier.getCustomMessage();
            }
            String replaced = this.tokenExpander.expand(customMessage, this.build);
            this.message.append("\n");
            this.message.append(replaced);
            return this;
        }

        private String getTestClassAndMethod(TestResult result) {
            String fullDisplayName = result.getFullDisplayName();
            if (StringUtils.countMatches((CharSequence)fullDisplayName, (CharSequence)".") > 1) {
                int methodDotIndex = fullDisplayName.lastIndexOf(46);
                int testClassDotIndex = fullDisplayName.substring(0, methodDotIndex).lastIndexOf(46);
                return fullDisplayName.substring(testClassDotIndex + 1);
            }
            return fullDisplayName;
        }

        private String createBackToNormalDurationString() {
            Run initialFailureAfterPreviousSuccessfulBuild;
            Run previousSuccessfulBuild = this.build.getPreviousSuccessfulBuild();
            if (null != previousSuccessfulBuild && null != previousSuccessfulBuild.getNextBuild() && (initialFailureAfterPreviousSuccessfulBuild = previousSuccessfulBuild.getNextBuild()) != null) {
                long initialFailureStartTime = initialFailureAfterPreviousSuccessfulBuild.getStartTimeInMillis();
                long initialFailureDuration = initialFailureAfterPreviousSuccessfulBuild.getDuration();
                long initialFailureEndTime = initialFailureStartTime + initialFailureDuration;
                long buildStartTime = this.build.getStartTimeInMillis();
                long buildDuration = this.build.getDuration();
                long buildEndTime = buildStartTime + buildDuration;
                long backToNormalDuration = buildEndTime - initialFailureEndTime;
                return Util.getTimeSpanString((long)backToNormalDuration);
            }
            return null;
        }

        private String escapeCharacters(String string) {
            string = string.replace("&", "&amp;");
            string = string.replace("<", "&lt;");
            string = string.replace(">", "&gt;");
            return string;
        }

        private String[] extractReplaceLinks(Matcher aTag, StringBuffer sb) {
            int size = 0;
            ArrayList<String> links = new ArrayList<String>();
            while (aTag.find()) {
                String firstGroup = aTag.group(1);
                if (firstGroup != null) {
                    Matcher url = href.matcher(firstGroup);
                    if (!url.find()) continue;
                    String escapeThis = aTag.group(3);
                    if (escapeThis != null) {
                        aTag.appendReplacement(sb, String.format("{%s}", size++));
                        links.add(escapeThis);
                        continue;
                    }
                    aTag.appendReplacement(sb, String.format("{%s}", size++));
                    links.add(String.format("<%s|%s>", url.group(1).replaceAll("\"", ""), aTag.group(2)));
                    continue;
                }
                String escapeThis = aTag.group(3);
                aTag.appendReplacement(sb, String.format("{%s}", size++));
                links.add(escapeThis);
            }
            aTag.appendTail(sb);
            return links.toArray(new String[size]);
        }

        public String escape(String string) {
            StringBuffer pattern = new StringBuffer();
            Object[] links = this.extractReplaceLinks(aTag.matcher(string), pattern);
            return MessageFormat.format(this.escapeCharacters(pattern.toString()), links);
        }

        public String toString() {
            return this.message.toString();
        }
    }
}

