/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.user;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.User;
import hudson.tasks.MailAddressResolver;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jenkins.plugins.slack.user.SlackUserIdResolver;
import jenkins.plugins.slack.user.SlackUserIdResolverDescriptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

public class EmailSlackUserIdResolver
extends SlackUserIdResolver {
    private static final Logger LOGGER = Logger.getLogger(EmailSlackUserIdResolver.class.getName());
    private static final String AUTHORIZATION_BEARER_TOKEN_FORMAT = "Bearer %s";
    private static final String LOOKUP_BY_EMAIL_METHOD_URL = "https://slack.com/api/users.lookupByEmail";
    private static final String LOOKUP_BY_EMAIL_METHOD_URL_FORMAT = "https://slack.com/api/users.lookupByEmail?email=%s";
    private static final String SLACK_OK_FIELD = "ok";
    private static final String SLACK_USER_FIELD = "user";
    private static final String SLACK_ID_FIELD = "id";
    private List<MailAddressResolver> mailAddressResolvers;
    private transient Function<User, String> defaultMailAddressResolver;

    @VisibleForTesting
    EmailSlackUserIdResolver(String authToken, CloseableHttpClient httpClient, List<MailAddressResolver> mailAddressResolvers, Function<User, String> defaultMailAddressResolver) {
        super(authToken, httpClient);
        this.mailAddressResolvers = mailAddressResolvers;
        this.defaultMailAddressResolver = defaultMailAddressResolver;
    }

    public EmailSlackUserIdResolver(String authToken, CloseableHttpClient httpClient, List<MailAddressResolver> mailAddressResolvers) {
        this(authToken, httpClient, mailAddressResolvers, MailAddressResolver::resolve);
    }

    public EmailSlackUserIdResolver(String authToken, CloseableHttpClient httpClient) {
        this(authToken, httpClient, null);
    }

    @DataBoundConstructor
    public EmailSlackUserIdResolver() {
        this(null, null);
    }

    public String getAPIMethodURL() {
        return LOOKUP_BY_EMAIL_METHOD_URL;
    }

    public void setMailAddressResolvers(List<MailAddressResolver> mailAddressResolvers) {
        this.mailAddressResolvers = mailAddressResolvers;
    }

    @Override
    protected String resolveUserId(User user) {
        Optional<String> userId = Optional.ofNullable(this.mailAddressResolvers).map(Collection::stream).orElseGet(Stream::empty).map(resolver -> {
            try {
                return resolver.findMailAddressFor(user);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, String.format("The email resolver '%s' failed", resolver.getClass().getName()), ex);
                return null;
            }
        }).filter(StringUtils::isNotEmpty).map(this::resolveUserIdForEmailAddress).filter(StringUtils::isNotEmpty).findAny();
        if (userId.isPresent()) {
            return userId.get();
        }
        if (this.defaultMailAddressResolver != null) {
            return this.resolveUserIdForEmailAddress(this.defaultMailAddressResolver.apply(user));
        }
        return null;
    }

    public String resolveUserIdForEmailAddress(String emailAddress) {
        if (StringUtils.isEmpty((CharSequence)emailAddress)) {
            LOGGER.fine("Email address was empty");
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)this.authToken)) {
            LOGGER.fine("Auth token was empty");
            return null;
        }
        String slackUserId = null;
        String url = String.format(LOOKUP_BY_EMAIL_METHOD_URL_FORMAT, emailAddress);
        HttpGet getRequest = new HttpGet(url);
        getRequest.addHeader("Content-Type", (Object)ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
        getRequest.addHeader("Authorization", (Object)String.format(AUTHORIZATION_BEARER_TOKEN_FORMAT, this.authToken));
        try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)getRequest);){
            HttpEntity entity;
            JSONObject slackResponse;
            int responseCode = response.getCode();
            if (200 == responseCode && (slackResponse = new JSONObject(EntityUtils.toString((HttpEntity)(entity = response.getEntity())))).optBoolean(SLACK_OK_FIELD)) {
                JSONObject slackUser = slackResponse.getJSONObject(SLACK_USER_FIELD);
                slackUserId = slackUser.getString(SLACK_ID_FIELD);
            }
        }
        catch (IOException | ParseException | JSONException ex) {
            LOGGER.log(Level.WARNING, "Error getting userId from Slack", ex);
        }
        return slackUserId;
    }

    @Extension
    public static class DescriptorImpl
    extends SlackUserIdResolverDescriptor {
        public String getDisplayName() {
            return "Slack email User ID Resolver";
        }
    }
}

