/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import jenkins.plugins.slack.SlackNotifier;
import jenkins.plugins.slack.matrix.MatrixTriggerMode;

@Extension(optional=true)
public class SlackMatrixBridge
implements MatrixAggregatable {
    public MatrixAggregator createAggregator(MatrixBuild matrixBuild, Launcher launcher, BuildListener buildListener) {
        return new MatrixAggregator(matrixBuild, launcher, buildListener){

            private boolean slackNotify() {
                MatrixTriggerMode matrixTriggerMode;
                SlackNotifier slackNotifier = (SlackNotifier)((MatrixProject)this.build.getParent()).getPublishersList().get(SlackNotifier.class);
                if (slackNotifier != null && (matrixTriggerMode = slackNotifier.getMatrixTriggerMode()) != null && matrixTriggerMode.forParent) {
                    return slackNotifier.perform((AbstractBuild<?, ?>)this.build, this.launcher, this.listener);
                }
                return true;
            }

            public boolean startBuild() {
                return this.slackNotify();
            }

            public boolean endBuild() {
                return this.slackNotify();
            }
        };
    }
}

