/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.pipeline;

import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.TaskListener;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.slack.HttpClient;
import jenkins.plugins.slack.pipeline.SlackFileRequest;
import jenkins.security.MasterToSlaveCallable;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.net.URIBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class SlackUploadFileRunner
extends MasterToSlaveCallable<Boolean, Throwable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String GET_UPLOAD_URL_API = "https://slack.com/api/files.getUploadURLExternal";
    private static final Logger logger = Logger.getLogger(SlackUploadFileRunner.class.getName());
    private static final String UPLOAD_FAILED_TEMPLATE = "Slack upload may have failed. Response: ";
    private final FilePath filePath;
    private final String fileToUploadPath;
    private final String channelId;
    private final String token;
    private final TaskListener listener;
    private final String initialComment;
    private final ProxyConfiguration proxy;
    private final String threadTs;

    public SlackUploadFileRunner(TaskListener listener, ProxyConfiguration proxy, SlackFileRequest slackFileRequest) {
        this.listener = listener;
        this.filePath = slackFileRequest.getFilePath();
        this.fileToUploadPath = slackFileRequest.getFileToUploadPath();
        this.channelId = slackFileRequest.getChannelId();
        this.threadTs = slackFileRequest.getThreadTs();
        this.initialComment = slackFileRequest.getInitialComment();
        this.token = slackFileRequest.getToken();
        this.proxy = proxy;
    }

    public Boolean call() throws Throwable {
        logger.fine(String.valueOf(this.filePath));
        logger.fine(this.fileToUploadPath);
        this.listener.getLogger().printf("Using dirname=%s and includeMask=%s%n", this.filePath.getRemote(), this.fileToUploadPath);
        final ArrayList<File> files = new ArrayList<File>();
        new DirScanner.Glob(this.fileToUploadPath, null).scan(new File(this.filePath.getRemote()), new FileVisitor(){

            public void visit(File file, String relativePath) {
                if (file.isFile()) {
                    SlackUploadFileRunner.this.listener.getLogger().println("Adding file " + file.getAbsolutePath());
                    files.add(file);
                }
            }
        });
        if (files.isEmpty()) {
            this.listener.getLogger().println("No files found for mask=" + String.valueOf(this.filePath));
            return false;
        }
        return this.doIt(files);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doIt(List<File> files) {
        ArrayList<String> fileIds = new ArrayList<String>();
        try (CloseableHttpClient client = HttpClient.getCloseableHttpClient(this.proxy);){
            for (File file : files) {
                MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.LEGACY).addBinaryBody("file", file, ContentType.DEFAULT_BINARY, file.getName());
                JSONObject getUploadUrlResult = this.getUploadUrlExternal(file, client);
                if (getUploadUrlResult == null) {
                    boolean bl = false;
                    return bl;
                }
                String uploadUrl = getUploadUrlResult.getString("upload_url");
                if (!this.uploadFile(uploadUrl, multipartEntityBuilder, client)) {
                    this.listener.getLogger().println("Failed to upload file to Slack");
                    boolean bl = false;
                    return bl;
                }
                String fileId = getUploadUrlResult.getString("file_id");
                fileIds.add(fileId);
            }
            if (this.completeUploadExternal(this.channelId, this.threadTs, fileIds, client)) return true;
            this.listener.getLogger().println("Failed to complete uploading file to Slack");
            boolean bl = false;
            return bl;
        }
        catch (IOException | URISyntaxException | ParseException e) {
            String msg = "Exception uploading to Slack ";
            logger.log(Level.WARNING, msg, e);
            this.listener.getLogger().println(msg + e.getMessage());
        }
        return true;
    }

    private boolean completeUploadExternal(String channelId, String threadTs, List<String> fileIds, CloseableHttpClient client) throws IOException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("channel_id", (Object)channelId);
        if (this.initialComment != null) {
            jsonObject.put("initial_comment", (Object)this.initialComment);
        }
        if (threadTs != null) {
            jsonObject.put("thread_ts", (Object)threadTs);
        }
        jsonObject.put("files", (Object)SlackUploadFileRunner.convertListToJsonArray(fileIds));
        Request completeRequest = Request.post((String)"https://slack.com/api/files.completeUploadExternal").body((HttpEntity)new StringEntity(jsonObject.toString(), ContentType.APPLICATION_JSON)).addHeader("Authorization", "Bearer " + this.token);
        JSONObject completeRequestResponse = (JSONObject)completeRequest.execute(client).handleResponse(this.getStandardResponseHandler());
        if (completeRequestResponse != null && !completeRequestResponse.getBoolean("ok")) {
            this.listener.getLogger().println(UPLOAD_FAILED_TEMPLATE + String.valueOf(completeRequestResponse));
            return false;
        }
        return true;
    }

    private static JSONArray convertListToJsonArray(List<String> fileIds) {
        JSONArray jsonArray = new JSONArray();
        fileIds.stream().map(fileId -> new JSONObject().put("id", fileId)).forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        return jsonArray;
    }

    private HttpClientResponseHandler<JSONObject> getStandardResponseHandler() {
        return response -> {
            int status = response.getCode();
            if (status >= 200 && status < 300) {
                HttpEntity entity = response.getEntity();
                return entity != null ? new JSONObject(EntityUtils.toString((HttpEntity)entity)) : null;
            }
            String errorMessage = UPLOAD_FAILED_TEMPLATE + status + " " + EntityUtils.toString((HttpEntity)response.getEntity());
            this.listener.getLogger().println(errorMessage);
            logger.log(Level.WARNING, errorMessage);
            return null;
        };
    }

    private boolean uploadFile(String uploadUrl, MultipartEntityBuilder multipartEntityBuilder, CloseableHttpClient client) throws IOException, ParseException {
        Request request = Request.post((String)uploadUrl).body(multipartEntityBuilder.build()).addHeader("Authorization", "Bearer " + this.token);
        Response responseBody = request.execute(client);
        if (responseBody.returnResponse().getCode() != 200) {
            this.listener.getLogger().println(UPLOAD_FAILED_TEMPLATE + responseBody.returnContent().asString());
            return false;
        }
        return true;
    }

    private JSONObject getUploadUrlExternal(File file, CloseableHttpClient client) throws IOException, URISyntaxException {
        URI uri = new URIBuilder(GET_UPLOAD_URL_API).addParameter("filename", file.getName()).addParameter("length", String.valueOf(file.length())).build();
        Request getUploadApiRequest = Request.get((URI)uri).addHeader("Authorization", "Bearer " + this.token);
        JSONObject getUploadRequestResponse = (JSONObject)getUploadApiRequest.execute(client).handleResponse(this.getStandardResponseHandler());
        if (getUploadRequestResponse != null && !getUploadRequestResponse.getBoolean("ok")) {
            this.listener.getLogger().println(UPLOAD_FAILED_TEMPLATE + String.valueOf(getUploadRequestResponse));
            return null;
        }
        if (getUploadRequestResponse == null) {
            this.listener.getLogger().println(UPLOAD_FAILED_TEMPLATE);
            return null;
        }
        return getUploadRequestResponse;
    }
}

