/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.decisions;

import java.util.function.Predicate;
import jenkins.plugins.slack.decisions.Context;
import jenkins.plugins.slack.logging.BuildAwareLogger;

interface Condition
extends Predicate<Context> {
    public boolean isMetBy(Context var1);

    public boolean userPreferenceMatches();

    public BuildAwareLogger log();

    @Override
    default public boolean test(Context context) {
        boolean isMet = this.isMetBy(context);
        boolean preferences = this.userPreferenceMatches();
        if (isMet) {
            if (preferences) {
                this.log().info(context.currentKey(), "will send " + this.getClass().getSimpleName() + "Notification because build matches and user preferences allow it", new Object[0]);
            } else {
                this.log().debug(context.currentKey(), "will NOT send " + this.getClass().getSimpleName() + "Notification - build matches but user preferences do not allow it", new Object[0]);
            }
        } else {
            this.log().debug(context.currentKey(), "does not match " + this.getClass().getSimpleName() + "Notification condition", new Object[0]);
        }
        return isMet && preferences;
    }
}

