/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import hudson.AbortException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.slack.HttpClient;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.json.JSONArray;
import org.json.JSONObject;

public class SlackChannelIdCache {
    private static final String UPLOAD_FAILED_TEMPLATE = "Failed to retrieve channel names. Response: ";
    private static final Logger logger = Logger.getLogger(SlackChannelIdCache.class.getName());
    private static final LoadingCache<String, Map<String, String>> CHANNEL_METADATA_CACHE = Caffeine.newBuilder().maximumSize(100L).refreshAfterWrite(Duration.ofHours(24L)).build(SlackChannelIdCache::populateCache);
    private static final int MAX_RETRIES = 10;

    private static Map<String, String> populateCache(String token) {
        Map<String, String> map;
        block8: {
            HttpClientBuilder closeableHttpClientBuilder = HttpClient.getCloseableHttpClientBuilder(Jenkins.get().getProxy()).setRetryStrategy(new HttpRequestRetryStrategy(){
                private long retryInterval;

                public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                    Header firstHeader;
                    boolean shouldRetry;
                    boolean bl = shouldRetry = executionCount <= 10 && response.getCode() == 429;
                    if (shouldRetry && (firstHeader = response.getFirstHeader("Retry-After")) != null) {
                        this.retryInterval = Long.parseLong(firstHeader.getValue()) * 1000L;
                        logger.info(String.format("Rate limited by Slack, retrying in %dms", this.retryInterval));
                    }
                    return shouldRetry;
                }

                public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
                    return false;
                }

                public TimeValue getRetryInterval(HttpResponse response, int execCount, HttpContext context) {
                    return TimeValue.ofSeconds((long)this.retryInterval);
                }
            });
            CloseableHttpClient client = closeableHttpClientBuilder.build();
            try {
                map = SlackChannelIdCache.convertChannelNameToId(client, token, new HashMap<String, String>(), null);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            client.close();
        }
        return map;
    }

    public static String getChannelId(String botUserToken, String channel) throws ExecutionException, InterruptedException, AbortException {
        String channelName = SlackChannelIdCache.cleanChannelName(channel);
        if (channelName.matches("^(C[A-Z0-9]{8}|C[A-Z0-9]{10}|G[A-Z0-9]{10}|D[A-Z0-9]{8})$")) {
            return channelName;
        }
        Map channelNameToIdMap = (Map)CHANNEL_METADATA_CACHE.get((Object)botUserToken);
        String channelId = (String)channelNameToIdMap.get(channelName);
        if (channelId == null) {
            try {
                CompletableFuture newResult = CHANNEL_METADATA_CACHE.refresh((Object)botUserToken);
                channelNameToIdMap = (Map)newResult.get();
            }
            catch (CompletionException e) {
                throw new AbortException("Failed uploading file to slack, channel not found: " + channelName + ", error: " + e.getMessage());
            }
            channelId = (String)channelNameToIdMap.get(channelName);
        }
        return channelId;
    }

    private static String cleanChannelName(String channelName) {
        String[] splitForThread = channelName.split(":", 2);
        String channel = channelName;
        if (splitForThread.length == 2) {
            channel = splitForThread[0];
        }
        if (channel.startsWith("#")) {
            return channel.substring(1);
        }
        return channel;
    }

    private static Map<String, String> convertChannelNameToId(CloseableHttpClient client, String token, Map<String, String> channels, String cursor) throws IOException, URISyntaxException {
        SlackChannelIdCache.convertPublicChannelNameToId(client, token, channels, cursor);
        SlackChannelIdCache.convertPrivateChannelNameToId(client, token, channels, cursor);
        return channels;
    }

    private static Map<String, String> convertPublicChannelNameToId(CloseableHttpClient client, String token, Map<String, String> channels, String cursor) throws IOException, URISyntaxException {
        Request requestBuilder;
        JSONObject result;
        URIBuilder uriBuilder = new URIBuilder("https://slack.com/api/conversations.list").addParameter("exclude_archived", "true").addParameter("types", "public_channel").addParameter("limit", "999");
        if (cursor != null) {
            uriBuilder.addParameter("cursor", cursor);
        }
        if (!(result = (JSONObject)(requestBuilder = Request.get((URI)uriBuilder.build()).addHeader("Authorization", "Bearer " + token)).execute(client).handleResponse(SlackChannelIdCache.getStandardResponseHandler())).getBoolean("ok")) {
            logger.warning("Couldn't convert channel name to ID in Slack: " + String.valueOf(result));
            return channels;
        }
        JSONArray channelsArray = result.getJSONArray("channels");
        for (int i = 0; i < channelsArray.length(); ++i) {
            JSONObject channel = channelsArray.getJSONObject(i);
            String channelName = channel.getString("name");
            String channelId = channel.getString("id");
            channels.put(channelName, channelId);
        }
        cursor = result.getJSONObject("response_metadata").getString("next_cursor");
        if (cursor != null && !cursor.isEmpty()) {
            return SlackChannelIdCache.convertPublicChannelNameToId(client, token, channels, cursor);
        }
        return channels;
    }

    private static Map<String, String> convertPrivateChannelNameToId(CloseableHttpClient client, String token, Map<String, String> channels, String cursor) throws IOException, URISyntaxException {
        Request requestBuilder;
        JSONObject result;
        URIBuilder uriBuilder = new URIBuilder("https://slack.com/api/conversations.list").addParameter("exclude_archived", "true").addParameter("types", "private_channel").addParameter("limit", "999");
        if (cursor != null) {
            uriBuilder.addParameter("cursor", cursor);
        }
        if (!(result = (JSONObject)(requestBuilder = Request.get((URI)uriBuilder.build()).addHeader("Authorization", "Bearer " + token)).execute(client).handleResponse(SlackChannelIdCache.getStandardResponseHandler())).getBoolean("ok")) {
            logger.warning("Couldn't convert channel name to ID in Slack: " + String.valueOf(result));
            return channels;
        }
        JSONArray channelsArray = result.getJSONArray("channels");
        for (int i = 0; i < channelsArray.length(); ++i) {
            JSONObject channel = channelsArray.getJSONObject(i);
            String channelName = channel.getString("name");
            String channelId = channel.getString("id");
            channels.put(channelName, channelId);
        }
        cursor = result.getJSONObject("response_metadata").getString("next_cursor");
        if (cursor != null && !cursor.isEmpty()) {
            return SlackChannelIdCache.convertPrivateChannelNameToId(client, token, channels, cursor);
        }
        return channels;
    }

    private static HttpClientResponseHandler<JSONObject> getStandardResponseHandler() {
        return response -> {
            int status = response.getCode();
            if (status >= 200 && status < 300) {
                HttpEntity entity = response.getEntity();
                return entity != null ? new JSONObject(EntityUtils.toString((HttpEntity)entity)) : null;
            }
            String errorMessage = UPLOAD_FAILED_TEMPLATE + status + " " + EntityUtils.toString((HttpEntity)response.getEntity());
            throw new HttpStatusCodeException(response.getCode(), errorMessage);
        };
    }

    public static void clearCache() {
        CHANNEL_METADATA_CACHE.invalidateAll();
    }

    public static class HttpStatusCodeException
    extends RuntimeException {
        private final int statusCode;

        public HttpStatusCodeException(int statusCode, String message) {
            super(message);
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

