/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.slack;

import java.util.Objects;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class SlackReactionRequest {
    private final String channelId;
    private final String timestamp;
    private final String emojiName;

    private SlackReactionRequest(String channelId, String timestamp, String emojiName) {
        if (StringUtils.isEmpty((CharSequence)channelId) || StringUtils.isEmpty((CharSequence)timestamp) || StringUtils.isEmpty((CharSequence)emojiName)) {
            throw new IllegalArgumentException("Slack reaction requires all of channelId, timestamp, and emojiName");
        }
        this.channelId = channelId;
        this.timestamp = timestamp;
        this.emojiName = emojiName;
    }

    public static SlackReactionRequestBuilder builder() {
        return new SlackReactionRequestBuilder();
    }

    public JSONObject getBody() {
        JSONObject json = new JSONObject();
        json.put("channel", (Object)this.channelId);
        json.put("timestamp", (Object)this.timestamp);
        json.put("name", (Object)this.emojiName);
        return json;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getEmojiName() {
        return this.emojiName;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackReactionRequest that = (SlackReactionRequest)o;
        return Objects.equals(this.channelId, that.channelId) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.emojiName, that.emojiName);
    }

    public String toString() {
        return String.format("SlackReactionRequest{channelId='%s', timestamp='%s', emojiName='%s'}", this.channelId, this.timestamp, this.emojiName);
    }

    public int hashCode() {
        return Objects.hash(this.channelId, this.timestamp, this.emojiName);
    }

    public static class SlackReactionRequestBuilder {
        private String channelId;
        private String timestamp;
        private String emojiName;

        private SlackReactionRequestBuilder() {
        }

        public SlackReactionRequestBuilder withChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public SlackReactionRequestBuilder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SlackReactionRequestBuilder withEmojiName(String emojiName) {
            this.emojiName = emojiName;
            return this;
        }

        public SlackReactionRequest build() {
            return new SlackReactionRequest(this.channelId, this.timestamp, this.emojiName);
        }
    }
}

