/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.simpletheme;

import hudson.Extension;
import hudson.ExtensionList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.csp.Contributor;
import jenkins.security.csp.CspBuilder;
import org.codefirst.SimpleThemeDecorator;
import org.jenkinsci.plugins.simpletheme.CssUrlThemeElement;
import org.jenkinsci.plugins.simpletheme.JsUrlThemeElement;
import org.jenkinsci.plugins.simpletheme.ThemeElement;
import org.jenkinsci.plugins.simpletheme.UrlThemeElement;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@SuppressRestrictedWarnings(value={Contributor.class, CspBuilder.class})
public class SimpleThemeUrlContributor
implements Contributor {
    private static final Logger LOGGER = Logger.getLogger(SimpleThemeUrlContributor.class.getName());

    public void apply(CspBuilder cspBuilder) {
        SimpleThemeDecorator decorator = (SimpleThemeDecorator)((Object)ExtensionList.lookupSingleton(SimpleThemeDecorator.class));
        for (ThemeElement element : decorator.getElements()) {
            String url;
            if (!(element instanceof UrlThemeElement) || (url = ((UrlThemeElement)element).getUrl()) == null || url.isEmpty()) continue;
            try {
                URI uri = new URI(url);
                if (uri.isAbsolute()) {
                    LOGGER.log(Level.FINE, "Allowing absolute URL in CSP: " + String.valueOf(uri));
                    if (element instanceof JsUrlThemeElement) {
                        cspBuilder.add("script-src", new String[]{uri.toString()});
                        continue;
                    }
                    if (!(element instanceof CssUrlThemeElement)) continue;
                    cspBuilder.add("style-src", new String[]{uri.toString()});
                    continue;
                }
                if (uri.getHost() == null || Stapler.getCurrentRequest2() == null) continue;
                StaplerRequest2 request = Stapler.getCurrentRequest2();
                String scheme = request.getScheme();
                LOGGER.log(Level.FINE, "Allowing scheme-relative URL in CSP: " + scheme + ":" + String.valueOf(uri));
                if (element instanceof JsUrlThemeElement) {
                    cspBuilder.add("script-src", new String[]{scheme + ":" + String.valueOf(uri)});
                    continue;
                }
                if (!(element instanceof CssUrlThemeElement)) continue;
                cspBuilder.add("style-src", new String[]{scheme + ":" + String.valueOf(uri)});
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

