/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.simpletheme;

import hudson.Extension;
import java.security.SecureRandom;
import java.util.Base64;
import jenkins.security.csp.Contributor;
import jenkins.security.csp.CspBuilder;
import jenkins.security.csp.FetchDirective;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@SuppressRestrictedWarnings(value={Contributor.class, CspBuilder.class, FetchDirective.class})
public class NonceContributor
implements Contributor {
    private static final SecureRandom RANDOM = new SecureRandom();

    public void apply(CspBuilder cspBuilder) {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req != null) {
            String nonce = NonceContributor.getOrGenerateNonce(req);
            cspBuilder.initialize(FetchDirective.SCRIPT_SRC, new String[]{"'self'"}).add("script-src-elem", new String[]{"'nonce-" + nonce + "'"});
        }
    }

    static synchronized String getOrGenerateNonce(StaplerRequest2 req) {
        if (req == null) {
            return null;
        }
        String nonce = (String)req.getAttribute(NonceContributor.class.getName());
        if (nonce == null) {
            byte[] bytes = new byte[32];
            RANDOM.nextBytes(bytes);
            nonce = Base64.getEncoder().encodeToString(bytes);
            req.setAttribute(NonceContributor.class.getName(), (Object)nonce);
        }
        return nonce;
    }
}

