/*
 * Decompiled with CFR 0.152.
 */
package org.codefirst;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.PageDecorator;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import jenkins.appearance.AppearanceCategory;
import jenkins.model.GlobalConfigurationCategory;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.simpletheme.CssTextThemeElement;
import org.jenkinsci.plugins.simpletheme.CssUrlThemeElement;
import org.jenkinsci.plugins.simpletheme.FaviconUrlThemeElement;
import org.jenkinsci.plugins.simpletheme.JsUrlThemeElement;
import org.jenkinsci.plugins.simpletheme.ThemeElement;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Symbol(value={"simpleTheme"})
public class SimpleThemeDecorator
extends PageDecorator {
    private List<ThemeElement> elements = new ArrayList<ThemeElement>();
    @Deprecated
    private transient String cssUrl;
    @Deprecated
    private transient String cssRules;
    @Deprecated
    private transient String jsUrl;
    @Deprecated
    private transient String faviconUrl;

    public SimpleThemeDecorator() {
        this.load();
    }

    public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
        this.elements.clear();
        req.bindJSON((Object)this, formData);
        this.save();
        return true;
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(AppearanceCategory.class);
    }

    public List<ThemeElement> getElements() {
        return this.elements;
    }

    @DataBoundSetter
    public void setElements(List<ThemeElement> elements) {
        this.elements = elements;
    }

    @Deprecated
    public String getCssUrl() {
        return this.cssUrl;
    }

    @DataBoundSetter
    @Deprecated
    public void setCssUrl(String cssUrl) {
        this.cssUrl = cssUrl;
    }

    @Deprecated
    public String getCssRules() {
        return this.cssRules;
    }

    @DataBoundSetter
    @Deprecated
    public void setCssRules(String cssRules) {
        this.cssRules = cssRules;
    }

    @Deprecated
    public String getJsUrl() {
        return this.jsUrl;
    }

    @DataBoundSetter
    @Deprecated
    public void setJsUrl(String jsUrl) {
        this.jsUrl = jsUrl;
    }

    @Deprecated
    public String getFaviconUrl() {
        return this.faviconUrl;
    }

    @DataBoundSetter
    @Deprecated
    public void setFaviconUrl(String faviconUrl) {
        this.faviconUrl = faviconUrl;
    }

    protected Object readResolve() {
        if (this.cssUrl != null && !this.cssUrl.isBlank()) {
            this.elements.add(new CssUrlThemeElement(this.cssUrl));
        }
        if (this.cssRules != null && !this.cssRules.isBlank()) {
            this.elements.add(new CssTextThemeElement(this.cssRules));
        }
        if (this.jsUrl != null && !this.jsUrl.isBlank()) {
            this.elements.add(new JsUrlThemeElement(this.jsUrl));
        }
        if (this.faviconUrl != null && !this.faviconUrl.isBlank()) {
            this.elements.add(new FaviconUrlThemeElement(this.faviconUrl));
        }
        return this;
    }

    public String getHeaderHtml() {
        LinkedHashSet<String> data = new LinkedHashSet<String>();
        boolean injectCss = this.shouldInjectCss();
        for (ThemeElement element : this.elements) {
            element.collectHeaderFragment(data, injectCss);
        }
        return String.join((CharSequence)"\n", data);
    }

    public boolean shouldInjectCss() {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req == null) {
            return false;
        }
        List ancestors = req.getAncestors();
        if (ancestors == null || ancestors.size() == 0) {
            return false;
        }
        Ancestor a = (Ancestor)ancestors.get(ancestors.size() - 1);
        Object o = a.getObject();
        return !o.getClass().getName().startsWith("com.smartcodeltd.jenkinsci.plugins.buildmonitor");
    }
}

