// CHECKSTYLE:OFF

package org.jenkinsci.plugins.simpletheme;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code cssText}: {@code Extra CSS}.
     * 
     * @return
     *     {@code Extra CSS}
     */
    public static String cssText() {
        return holder.format("cssText");
    }

    /**
     * Key {@code cssText}: {@code Extra CSS}.
     * 
     * @return
     *     {@code Extra CSS}
     */
    public static Localizable _cssText() {
        return new Localizable(holder, "cssText");
    }

    /**
     * Key {@code faviconURL}: {@code Favicon URL}.
     * 
     * @return
     *     {@code Favicon URL}
     */
    public static String faviconURL() {
        return holder.format("faviconURL");
    }

    /**
     * Key {@code faviconURL}: {@code Favicon URL}.
     * 
     * @return
     *     {@code Favicon URL}
     */
    public static Localizable _faviconURL() {
        return new Localizable(holder, "faviconURL");
    }

    /**
     * Key {@code cssURL}: {@code CSS URL}.
     * 
     * @return
     *     {@code CSS URL}
     */
    public static String cssURL() {
        return holder.format("cssURL");
    }

    /**
     * Key {@code cssURL}: {@code CSS URL}.
     * 
     * @return
     *     {@code CSS URL}
     */
    public static Localizable _cssURL() {
        return new Localizable(holder, "cssURL");
    }

    /**
     * Key {@code jsURL}: {@code JavaScript URL}.
     * 
     * @return
     *     {@code JavaScript URL}
     */
    public static String jsURL() {
        return holder.format("jsURL");
    }

    /**
     * Key {@code jsURL}: {@code JavaScript URL}.
     * 
     * @return
     *     {@code JavaScript URL}
     */
    public static Localizable _jsURL() {
        return new Localizable(holder, "jsURL");
    }

}
