/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sidebar_link;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.sidebar_link.LinkAction;
import hudson.plugins.sidebar_link.LinkProtection;
import hudson.plugins.sidebar_link.Messages;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"sidebarGlobalLink"})
public class SidebarLinkPlugin
extends GlobalConfiguration {
    private List<LinkAction> links = new ArrayList<LinkAction>();

    public SidebarLinkPlugin() {
        this.load();
        Jenkins.get().getActions().addAll(this.links);
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        super.configure(req, json);
        if (!json.containsKey((Object)"links")) {
            this.setLinks(Collections.emptyList());
        }
        return true;
    }

    public List<LinkAction> getLinks() {
        return this.links;
    }

    @DataBoundSetter
    public void setLinks(List<LinkAction> links) {
        Jenkins.get().getActions().removeAll(this.links);
        this.links.clear();
        this.links.addAll(links);
        Jenkins.get().getActions().addAll(this.links);
        this.save();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doUploadLinkImage(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Hudson.ADMINISTER);
        FileItem file = req.getFileItem("linkimage.file");
        String error = null;
        String filename = null;
        if (file == null || file.getName().isEmpty()) {
            error = Messages.NoFile();
        } else {
            filename = "userContent/" + file.getName().replaceFirst(".*/", "").replaceAll("[^\\w.,;:()#@!=+-]", "_");
            FilePath imageFile = jenkins.getRootPath().child(filename);
            if (imageFile.exists()) {
                error = Messages.DupName();
            } else {
                imageFile.copyFrom(file.getInputStream());
                imageFile.chmod(420);
            }
        }
        rsp.setContentType("text/html");
        rsp.getWriter().println((error != null ? error : Messages.Uploaded("<code>/" + filename + "</code>")) + " <a href=\"javascript:history.back()\">" + Messages.Back() + "</a>");
    }

    @Restricted(value={NoExternalUse.class})
    public FormValidation doCheckLinkUrl(@QueryParameter String value) {
        return LinkProtection.verifyUrl(value);
    }

    @Restricted(value={NoExternalUse.class})
    public FormValidation doCheckLinkText(@QueryParameter String value) {
        if (value == null || value.isBlank()) {
            return FormValidation.error((String)"The provided text is blank or empty");
        }
        return FormValidation.ok();
    }

    @Restricted(value={NoExternalUse.class})
    public FormValidation doCheckLinkIcon(@QueryParameter String value) {
        if (value == null || value.isBlank()) {
            return FormValidation.warning((String)"The provided icon is blank or empty. Default will be used: icon-help icon-md");
        }
        if (value.equals("icon-help icon-md")) {
            return FormValidation.ok();
        }
        if (this.isAcceptedIconName(value)) {
            return FormValidation.ok();
        }
        try {
            File jenkinsHomeDirectory = Jenkins.get().getRootDir();
            String userContentDirectory = jenkinsHomeDirectory.getCanonicalPath() + File.separatorChar + "userContent" + File.separatorChar;
            File imageFile = new File(jenkinsHomeDirectory, value);
            String canonicalPath = imageFile.getCanonicalPath();
            if (!canonicalPath.startsWith(userContentDirectory)) {
                return FormValidation.error((String)"Use path to JENKINS_HOME/userContent directory, eg. userContent/myIcon.png");
            }
            if (!imageFile.exists()) {
                return FormValidation.error((String)"Image does not exist. Open browser with /userContent to check available images");
            }
        }
        catch (IOException e) {
            return FormValidation.error((Throwable)e, (String)("Problem with link icon:  " + value));
        }
        return FormValidation.ok();
    }

    public boolean isAcceptedIconName(String iconName) {
        return iconName.matches("^[\\w-]+(\\.gif)?$");
    }
}

