/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sidebar_link;

import hudson.model.Action;
import hudson.plugins.sidebar_link.LinkProtection;
import hudson.util.FormValidation;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class LinkAction
implements Action {
    public static final String DEFAULT_ICON_NAME = "icon-help icon-md";
    private final String url;
    private final String text;
    private final String icon;
    @CheckForNull
    private transient Boolean isSafe = null;
    private static final Logger LOGGER = Logger.getLogger(LinkAction.class.getName());

    @DataBoundConstructor
    public LinkAction(String urlName, String displayName, String iconFileName) throws IllegalArgumentException {
        FormValidation validationResult = LinkProtection.verifyUrl(urlName);
        if (validationResult.kind == FormValidation.Kind.ERROR) {
            throw new IllegalArgumentException((Throwable)validationResult);
        }
        this.url = urlName;
        this.text = displayName;
        this.icon = iconFileName == null || iconFileName.isBlank() ? DEFAULT_ICON_NAME : iconFileName;
        LOGGER.info(String.format("Created link '%s': url='%s', icon='%s'", this.text, this.url, this.icon));
    }

    public String getUrlName() {
        if (this.isSafe == null) {
            FormValidation validationResult = LinkProtection.verifyUrl(this.url);
            this.isSafe = validationResult.kind != FormValidation.Kind.ERROR;
        }
        return this.isSafe != false ? this.url : "unsafeLink-" + this.url.hashCode();
    }

    public String getDisplayName() {
        return this.text;
    }

    public String getIconFileName() {
        return this.icon;
    }

    @Restricted(value={NoExternalUse.class})
    public String getUnprotectedUrlName() {
        return this.url;
    }

    @Restricted(value={NoExternalUse.class})
    public Object getAncestor() {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        if (currentRequest != null) {
            int listSize;
            List ancestors = currentRequest.getAncestors();
            int n = listSize = ancestors != null ? ancestors.size() : 0;
            if (ancestors == null || listSize < 2) {
                return null;
            }
            return ((Ancestor)ancestors.get(listSize - 2)).getObject();
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public String getAllowedSchemes() {
        return LinkProtection.getAllowedUriSchemes();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkAction)) {
            return false;
        }
        LinkAction c = (LinkAction)o;
        return this.text.equals(c.text) && this.icon.equals(c.icon) && this.url.equals(c.url);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.icon, this.url);
    }
}

