/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.secure_requester_whitelist;

import hudson.Extension;
import hudson.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import jenkins.security.SecureRequester;
import org.jenkinsci.plugins.secure_requester_whitelist.Whitelist;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class SecureRequesterImpl
implements SecureRequester {
    public boolean permit(StaplerRequest2 req, Object bean) {
        URI uri;
        Whitelist wl = Whitelist.get();
        String referer = req.getReferer();
        if (referer == null) {
            return wl.isAllowNoReferer();
        }
        try {
            uri = new URI(referer);
        }
        catch (URISyntaxException x) {
            return false;
        }
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(Util.fixNull((String)wl.getDomains()));
        while (tok.hasMoreTokens()) {
            String domain = tok.nextToken();
            if (!("." + host).endsWith("." + domain)) continue;
            return true;
        }
        return false;
    }
}

