/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.plugins.sectioned_view.SectionedViewSectionDescriptor;
import hudson.util.DescribableList;
import hudson.util.EnumConverter;
import hudson.views.ViewJobFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.Stapler;

public abstract class SectionedViewSection
implements ExtensionPoint,
Describable<SectionedViewSection> {
    final SortedSet<String> jobNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> jobFilters;
    private String name;
    String includeRegex;
    boolean executingRegexOnAllJobs;
    transient Pattern includePattern;
    private Width width;
    private Positioning alignment;
    transient String css;

    public SectionedViewSection(String name, Width width, Positioning alignment) {
        this.name = name;
        this.width = width;
        this.alignment = alignment;
        this.determineCss();
        this.initJobFilters();
    }

    public static DescriptorExtensionList<SectionedViewSection, SectionedViewSectionDescriptor> all() {
        return Hudson.getInstance().getDescriptorList(SectionedViewSection.class);
    }

    @NonNull
    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIncludeRegex() {
        return this.includeRegex;
    }

    public void setIncludeRegex(String regex) throws PatternSyntaxException {
        this.includeRegex = regex;
        this.includePattern = Pattern.compile(regex);
    }

    public boolean isExecutingRegexOnAllJobs() {
        return this.executingRegexOnAllJobs;
    }

    public void setExecutingRegexOnAllJobs(boolean value) {
        this.executingRegexOnAllJobs = value;
    }

    public Iterable<ViewJobFilter> getJobFilters() {
        return this.jobFilters;
    }

    @Deprecated
    public boolean hasJobFilterExtensions() {
        return this.getDescriptor().hasJobFilterExtensions();
    }

    public Width getWidth() {
        return this.width;
    }

    public void setWidth(Width width) {
        this.width = width;
    }

    public Positioning getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Positioning alignment) {
        this.alignment = alignment;
    }

    public boolean contains(TopLevelItem item, ItemGroup<? extends TopLevelItem> itemGroup) {
        return this.jobNames.contains(item.getRelativeNameFrom(itemGroup));
    }

    protected Object readResolve() {
        if (this.includeRegex != null) {
            this.setIncludeRegex(this.includeRegex);
        }
        if (this.width == null) {
            this.width = Width.FULL;
        }
        if (this.alignment == null) {
            this.alignment = Positioning.CENTER;
        }
        this.determineCss();
        this.initJobFilters();
        return this;
    }

    private void determineCss() {
        StringBuffer css = new StringBuffer();
        css.append(this.alignment.getCss());
        if (this.width == Width.THIRD && this.alignment == Positioning.CENTER) {
            css.append("width: 34%; ");
        } else {
            css.append(this.width.getCss());
        }
        if (this.width == Width.FULL) {
            css.append("clear: both; ");
        } else if (this.alignment == Positioning.LEFT) {
            css.append("clear: left; ");
        } else if (this.alignment == Positioning.RIGHT || this.alignment == Positioning.CENTER) {
            css.append("clear: right; ");
        }
        this.css = css.toString();
    }

    public Collection<TopLevelItem> getItems(ItemGroup<? extends TopLevelItem> itemGroup) {
        TreeSet<String> names = new TreeSet<String>(this.jobNames);
        Collection topLevelItems = null;
        topLevelItems = this.executingRegexOnAllJobs ? Items.getAllItems(itemGroup, TopLevelItem.class) : itemGroup.getItems();
        if (this.includePattern != null) {
            for (TopLevelItem item : topLevelItems) {
                String itemName = item.getRelativeNameFrom(itemGroup);
                if (!this.includePattern.matcher(itemName).matches()) continue;
                names.add(itemName);
            }
        }
        List<Object> items = new ArrayList<TopLevelItem>(names.size());
        for (String n : names) {
            TopLevelItem item;
            Jenkins instance = Jenkins.getInstance();
            if (instance == null || (item = (TopLevelItem)instance.getItem(n, itemGroup, TopLevelItem.class)) == null) continue;
            items.add(item);
        }
        Iterable<ViewJobFilter> jobFilters = this.getJobFilters();
        ArrayList allItems = new ArrayList(topLevelItems);
        for (ViewJobFilter jobFilter : jobFilters) {
            items = jobFilter.filter(items, allItems, null);
        }
        return items;
    }

    protected void initJobFilters() {
        if (this.jobFilters != null) {
            return;
        }
        ArrayList r = new ArrayList();
        this.jobFilters = new DescribableList(Saveable.NOOP, r);
    }

    public SectionedViewSectionDescriptor getDescriptor() {
        return (SectionedViewSectionDescriptor)Hudson.getInstance().getDescriptor(this.getClass());
    }

    public String getCss() {
        return this.css;
    }

    public static enum Width {
        FULL("Full", 100, "width: 100%; "),
        HALF("1/2", 50, "width: 50%; "),
        THIRD("1/3", 33, "width: 33%; "),
        TWO_THIRDS("2/3", 66, "width: 66%; ");

        private final String description;
        private final String css;
        private final int percent;

        public String getDescription() {
            return this.description;
        }

        public String getCss() {
            return this.css;
        }

        public int getPercent() {
            return this.percent;
        }

        public String getName() {
            return this.name();
        }

        private Width(String description, int percent, String css) {
            this.description = description;
            this.percent = percent;
            this.css = css;
        }

        static {
            Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), Width.class);
        }
    }

    public static enum Positioning {
        CENTER("Center", "margin-left: auto; margin-right: auto; float: left;"),
        LEFT("Left", "float: left; "),
        RIGHT("Right", "float: right; ");

        private final String description;
        private final String css;

        public String getDescription() {
            return this.description;
        }

        public String getCss() {
            return this.css;
        }

        public String getName() {
            return this.name();
        }

        private Positioning(String description, String css) {
            this.description = description;
            this.css = css;
        }

        static {
            Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), Positioning.class);
        }
    }
}

