/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.google.common.base.Joiner;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import hudson.plugins.sectioned_view.SectionedView;
import hudson.plugins.sectioned_view.SectionedViewSection;
import hudson.plugins.sectioned_view.SectionedViewSectionDescriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FolderViewSection
extends SectionedViewSection {
    private int viewColumns;
    private Integer folderLevels;
    private boolean hideJobs;
    private String regexFilter;
    private transient Pattern regexFilterPattern;

    @DataBoundConstructor
    public FolderViewSection(String name, SectionedViewSection.Width width, SectionedViewSection.Positioning alignment, int viewColumns, int folderLevels, boolean hideJobs, String regexFilter) {
        super(name, width, alignment);
        this.setViewColumns(viewColumns);
        this.setFolderLevels(folderLevels);
        this.setHideJobs(hideJobs);
        this.setRegexFilter(regexFilter);
    }

    public boolean isChecked(Folder folder, ItemGroup itemGroup) {
        Collection<TopLevelItem> selectedItems = this.getItems((ItemGroup<? extends TopLevelItem>)itemGroup);
        for (TopLevelItem item : selectedItems) {
            if (folder != item) continue;
            return true;
        }
        return false;
    }

    public List<List<Node>> getColumnsWithContent(ItemGroup<? extends TopLevelItem> itemGroup, int baseFolderLevel) {
        ArrayList<List<Node>> columns = new ArrayList<List<Node>>();
        for (int i = 0; i < this.viewColumns; ++i) {
            columns.add(new ArrayList());
        }
        List<Node> filteredNodes = this.convert(this.getItems(itemGroup), baseFolderLevel);
        int columnIndex = 0;
        for (Node node : filteredNodes) {
            ((List)columns.get(columnIndex)).add(node);
            columnIndex = columnIndex == this.viewColumns - 1 ? 0 : columnIndex + 1;
        }
        return columns;
    }

    public List<Node> convert(Collection<TopLevelItem> items, int baseFolderLevel) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (TopLevelItem item : items) {
            Node node = new Node((Item)item);
            this.addChildren(item, node, baseFolderLevel);
            nodes.add(node);
        }
        return nodes;
    }

    public void addChildren(TopLevelItem item, Node node, int baseFolderLevel) {
        Folder folder;
        if (item instanceof Folder && (folder = (Folder)item).getItems() != null) {
            node.setChildNodes(new ArrayList<Node>());
            for (TopLevelItem childItem : folder.getItems()) {
                if (!this.filter(childItem, baseFolderLevel)) continue;
                Node childNode = new Node((Item)childItem);
                node.getChildNodes().add(childNode);
                this.addChildren(childItem, childNode, baseFolderLevel);
            }
        }
    }

    private boolean filter(TopLevelItem item, int baseFolderLevel) {
        boolean allow = true;
        if (!(item instanceof Folder) & this.hideJobs) {
            allow = false;
        }
        if (this.regexFilter != null && !this.regexFilter.isEmpty() && !this.regexFilterPattern.matcher(item.getName()).matches()) {
            allow = false;
        }
        if (this.folderLevels != null && item.getFullName().length() - item.getFullName().replace("/", "").length() > this.folderLevels + baseFolderLevel) {
            allow = false;
        }
        return allow;
    }

    public Integer getFolderLevels() {
        return this.folderLevels;
    }

    public void setFolderLevels(Integer folderLevels) {
        this.folderLevels = folderLevels;
    }

    public boolean isHideJobs() {
        return this.hideJobs;
    }

    public void setHideJobs(boolean hideJobs) {
        this.hideJobs = hideJobs;
    }

    public String getRegexFilter() {
        return this.regexFilter;
    }

    public void setRegexFilter(String regexFilter) {
        this.regexFilter = regexFilter;
        this.regexFilterPattern = Pattern.compile(regexFilter);
    }

    public int getViewColumns() {
        return this.viewColumns;
    }

    public void setViewColumns(int viewColumns) {
        this.viewColumns = viewColumns;
    }

    public String getSelectedFoldersString(ItemGroup<? extends TopLevelItem> itemGroup) {
        Collection<TopLevelItem> selectedItems;
        String parentName = "";
        if (itemGroup instanceof Folder) {
            Folder folder = (Folder)itemGroup;
            parentName = folder.getFullName();
        }
        if ((selectedItems = this.getItems(itemGroup)) == null || selectedItems.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (TopLevelItem item : selectedItems) {
            if (parentName.length() >= item.getFullName().length()) continue;
            String itemFullName = item.getFullName().substring(parentName.length());
            itemFullName = itemFullName.charAt(0) == '/' ? itemFullName.substring(1) : itemFullName;
            buf.append(",").append(itemFullName.replace("/", "$"));
        }
        return buf.substring(1);
    }

    public int baseFolderLevel(SectionedView sectionedView) {
        return FolderViewSection.calculateBaseFolderLevel(sectionedView);
    }

    private static int calculateBaseFolderLevel(SectionedView sectionedView) {
        int folderLevel = 0;
        if (sectionedView.getOwner() instanceof Folder) {
            Folder folder = (Folder)sectionedView.getOwner();
            folderLevel = FolderViewSection.folderLevel(folder.getFullName()) + 1;
        }
        return folderLevel;
    }

    private static int folderLevel(String fullName) {
        return fullName.length() - fullName.replace("/", "").length();
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        if (this.regexFilter != null) {
            this.regexFilterPattern = Pattern.compile(this.regexFilter);
        }
        return this;
    }

    public static class Node {
        private Item item;
        private List<Node> childNodes;

        public Node(Item item) {
            this.item = item;
        }

        public String getName() {
            return this.item.getDisplayName();
        }

        public void setChildNodes(List<Node> childNodes) {
            this.childNodes = childNodes;
        }

        public List<Node> getChildNodes() {
            return this.childNodes;
        }

        public Item getItem() {
            return this.item;
        }

        public String getUrl() {
            if (this.item.getParent() instanceof Folder) {
                Folder folder = (Folder)this.item.getParent();
                return "job/" + this.encodePathSegments(folder.getFullName()).replace("/", "/job/") + "/" + this.item.getParent().getUrlChildPrefix() + "/" + Util.rawEncode((String)this.item.getName()) + "/";
            }
            return "job/" + Util.rawEncode((String)this.item.getName()) + "/";
        }

        private String encodePathSegments(String uri) {
            Object[] segments = uri.split("/");
            for (int i = 0; i < segments.length; ++i) {
                segments[i] = Util.rawEncode((String)segments[i]);
            }
            return Joiner.on((String)"/").join(segments);
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends SectionedViewSectionDescriptor {
        public DescriptorImpl() throws Exception {
            if (Jenkins.getInstance().getPlugin("cloudbees-folder") == null) {
                throw new Exception("Can't instantiate without CloudBees Folder plugin installed");
            }
        }

        public String getDisplayName() {
            return "Folder Listing Section";
        }

        public FormValidation doCheckViewColumns(@QueryParameter String value) {
            int columns;
            if (StringUtils.isNotEmpty((String)value) && StringUtils.isNumeric((String)value) && (columns = Integer.parseInt(value)) > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Columns must be a number greater than 0");
        }

        public FormValidation doCheckFolderLevels(@QueryParameter String value) {
            int columns;
            if (StringUtils.isNotEmpty((String)value) && StringUtils.isNumeric((String)value) && (columns = Integer.parseInt(value)) > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Levels must be a number greater than 0");
        }

        public Collection<Item> getAllFolders(ItemGroup<Item> itemGroup) {
            Collection items = itemGroup.getItems(item -> item instanceof Folder);
            return items;
        }
    }
}

