/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.plugins.sectioned_view.SectionedViewSection;
import hudson.plugins.sectioned_view.SectionedViewSectionDescriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class ViewListingSection
extends SectionedViewSection {
    private List<String> views;
    private int columns;

    @DataBoundConstructor
    public ViewListingSection(String name, SectionedViewSection.Width width, SectionedViewSection.Positioning alignment, List<String> views, int columns) {
        super(name, width, alignment);
        this.setViews(views);
        this.setColumns(columns);
    }

    public void setViews(List<String> views) {
        this.views = views;
    }

    public List<String> getViews() {
        return this.views;
    }

    public boolean isChecked(String viewName) {
        return this.views.contains(viewName);
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getColumns() {
        return this.columns;
    }

    public List<Collection<View>> getNestedViewColumns(ViewGroup viewGroup) {
        ArrayList<Collection<View>> nestedViewColumns = new ArrayList<Collection<View>>();
        for (int i = 0; i < this.columns; ++i) {
            nestedViewColumns.add(new ArrayList());
        }
        if (this.views == null || this.views.isEmpty()) {
            return nestedViewColumns;
        }
        int column = 0;
        for (String viewName : this.views) {
            String[] viewComponents = viewName.split("\\$");
            View view = viewGroup.getView(viewComponents[0]);
            if (view == null) continue;
            boolean skipView = false;
            for (int i = 1; i < viewComponents.length; ++i) {
                if (view instanceof ViewGroup) {
                    if ((view = ((ViewGroup)view).getView(viewComponents[i])) != null) continue;
                    skipView = true;
                    break;
                }
                skipView = true;
                break;
            }
            if (skipView) continue;
            ((Collection)nestedViewColumns.get(column % this.columns)).add(view);
            ++column;
        }
        return nestedViewColumns;
    }

    @Extension
    public static final class DescriptorImpl
    extends SectionedViewSectionDescriptor {
        @Override
        public SectionedViewSection newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            int columns = formData.getInt("columns");
            if (columns <= 0) {
                throw new Descriptor.FormException("Columns must be a number greater than 0", "columns");
            }
            return (SectionedViewSection)req.bindJSON(((Object)((Object)this)).getClass().getDeclaringClass(), formData);
        }

        public String getDisplayName() {
            return "View Listing Section";
        }

        public FormValidation doCheckColumns(@QueryParameter String value) {
            int columns;
            if (StringUtils.isNotEmpty((String)value) && StringUtils.isNumeric((String)value) && (columns = Integer.parseInt(value)) > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Columns must be a number greater than 0");
        }
    }
}

