/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler;

import hudson.init.InitMilestone;
import hudson.init.Initializer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.scriptler.ScriptlerManagement;
import org.jenkinsci.plugins.scriptler.SyncUtil;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;

public final class ScriptlerLoadingTasks {
    private static final Logger LOGGER = Logger.getLogger(ScriptlerLoadingTasks.class.getName());

    private ScriptlerLoadingTasks() {
    }

    @Initializer(after=InitMilestone.PLUGINS_PREPARED)
    public static void synchronizeConfig() throws IOException {
        Path scriptDirectory;
        LOGGER.info("initialize Scriptler");
        Path homeDirectory = ScriptlerManagement.getScriptlerHomeDirectory2();
        if (!Files.isDirectory(homeDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(homeDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e, () -> "could not create Scriptler home directory: " + String.valueOf(homeDirectory));
            }
        }
        if (!Files.isDirectory(scriptDirectory = ScriptlerManagement.getScriptDirectory2(), new LinkOption[0])) {
            try {
                Files.createDirectory(scriptDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e, () -> "could not create Scriptler scripts directory: " + String.valueOf(scriptDirectory));
            }
        }
        ScriptlerConfiguration cfg = ScriptlerConfiguration.load();
        SyncUtil.syncDirWithCfg(scriptDirectory, cfg);
        cfg.save();
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void setupExistingScripts() {
        for (Script script : ScriptlerConfiguration.getConfiguration().getScripts()) {
            Path scriptFile = ScriptlerManagement.getScriptDirectory2().resolve(script.getScriptPath());
            try {
                String scriptSource = ScriptHelper.readScriptFromFile(scriptFile);
                ScriptHelper.putScriptInApprovalQueueIfRequired(scriptSource);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Source file for the script [{0}] was not found", script.getId());
            }
        }
    }
}

