// CHECKSTYLE:OFF

package org.jenkinsci.plugins.scriptler;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code scriptNotDefined}: {@code there is no script for scriptler

     * defined, please fix your configuration!}.
     * 
     * @return
     *     {@code there is no script for scriptler defined, please fix your

     *     configuration!}
     */
    public static String scriptNotDefined() {
        return holder.format("scriptNotDefined");
    }

    /**
     * Key {@code scriptNotDefined}: {@code there is no script for scriptler

     * defined, please fix your configuration!}.
     * 
     * @return
     *     {@code there is no script for scriptler defined, please fix your

     *     configuration!}
     */
    public static Localizable _scriptNotDefined() {
        return new Localizable(holder, "scriptNotDefined");
    }

    /**
     * Key {@code permissons_runScript_description}: {@code Allow execution

     * of Scriptler scripts and insertion / modification of Scriptler build

     * steps, allow fine grain tuning instead of giving Overall/RunScripts to

     * everyone}.
     * 
     * @return
     *     {@code Allow execution of Scriptler scripts and insertion /

     *     modification of Scriptler build steps, allow fine grain tuning instead

     *     of giving Overall/RunScripts to everyone}
     */
    public static String permissons_runScript_description() {
        return holder.format("permissons_runScript_description");
    }

    /**
     * Key {@code permissons_runScript_description}: {@code Allow execution

     * of Scriptler scripts and insertion / modification of Scriptler build

     * steps, allow fine grain tuning instead of giving Overall/RunScripts to

     * everyone}.
     * 
     * @return
     *     {@code Allow execution of Scriptler scripts and insertion /

     *     modification of Scriptler build steps, allow fine grain tuning instead

     *     of giving Overall/RunScripts to everyone}
     */
    public static Localizable _permissons_runScript_description() {
        return new Localizable(holder, "permissons_runScript_description");
    }

    /**
     * Key {@code permissons_title}: {@code Scriptler}.
     * 
     * @return
     *     {@code Scriptler}
     */
    public static String permissons_title() {
        return holder.format("permissons_title");
    }

    /**
     * Key {@code permissons_title}: {@code Scriptler}.
     * 
     * @return
     *     {@code Scriptler}
     */
    public static Localizable _permissons_title() {
        return new Localizable(holder, "permissons_title");
    }

    /**
     * Key {@code scriptNotUsableInBuildStep}: {@code The script [{0}] is not

     * usable in a build step, please review your configuration.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The script [{0}] is not usable in a build step, please review

     *     your configuration.}
     */
    public static String scriptNotUsableInBuildStep(Object arg0) {
        return holder.format("scriptNotUsableInBuildStep", arg0);
    }

    /**
     * Key {@code scriptNotUsableInBuildStep}: {@code The script [{0}] is not

     * usable in a build step, please review your configuration.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The script [{0}] is not usable in a build step, please review

     *     your configuration.}
     */
    public static Localizable _scriptNotUsableInBuildStep(Object arg0) {
        return new Localizable(holder, "scriptNotUsableInBuildStep", arg0);
    }

    /**
     * Key {@code parameterExtractionFailed}: {@code failed to read

     * parameters from request}.
     * 
     * @return
     *     {@code failed to read parameters from request}
     */
    public static String parameterExtractionFailed() {
        return holder.format("parameterExtractionFailed");
    }

    /**
     * Key {@code parameterExtractionFailed}: {@code failed to read

     * parameters from request}.
     * 
     * @return
     *     {@code failed to read parameters from request}
     */
    public static Localizable _parameterExtractionFailed() {
        return new Localizable(holder, "parameterExtractionFailed");
    }

    /**
     * Key {@code description}: {@code Store/edit/run scripts on any of the

     * agents or the built-in node.}.
     * 
     * @return
     *     {@code Store/edit/run scripts on any of the agents or the built-in

     *     node.}
     */
    public static String description() {
        return holder.format("description");
    }

    /**
     * Key {@code description}: {@code Store/edit/run scripts on any of the

     * agents or the built-in node.}.
     * 
     * @return
     *     {@code Store/edit/run scripts on any of the agents or the built-in

     *     node.}
     */
    public static Localizable _description() {
        return new Localizable(holder, "description");
    }

    /**
     * Key {@code download_failed}: {@code The import of the script [{0}]

     * from catalog [{1}] failed.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The import of the script [{0}] from catalog [{1}] failed.}
     */
    public static String download_failed(Object arg0, Object arg1) {
        return holder.format("download_failed", arg0, arg1);
    }

    /**
     * Key {@code download_failed}: {@code The import of the script [{0}]

     * from catalog [{1}] failed.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The import of the script [{0}] from catalog [{1}] failed.}
     */
    public static Localizable _download_failed(Object arg0, Object arg1) {
        return new Localizable(holder, "download_failed", arg0, arg1);
    }

    /**
     * Key {@code tokenmacro_AdminScriptOnly}: {@code The script [{0}]

     * exists, but is marked to be used by admins only and is therefore not

     * allowed for usage in the TokenMacro.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The script [{0}] exists, but is marked to be used by admins

     *     only and is therefore not allowed for usage in the TokenMacro.}
     */
    public static String tokenmacro_AdminScriptOnly(Object arg0) {
        return holder.format("tokenmacro_AdminScriptOnly", arg0);
    }

    /**
     * Key {@code tokenmacro_AdminScriptOnly}: {@code The script [{0}]

     * exists, but is marked to be used by admins only and is therefore not

     * allowed for usage in the TokenMacro.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The script [{0}] exists, but is marked to be used by admins

     *     only and is therefore not allowed for usage in the TokenMacro.}
     */
    public static Localizable _tokenmacro_AdminScriptOnly(Object arg0) {
        return new Localizable(holder, "tokenmacro_AdminScriptOnly", arg0);
    }

    /**
     * Key {@code scriptNotFound}: {@code could not find script with id

     * [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code could not find script with id [{0}]}
     */
    public static String scriptNotFound(Object arg0) {
        return holder.format("scriptNotFound", arg0);
    }

    /**
     * Key {@code scriptNotFound}: {@code could not find script with id

     * [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code could not find script with id [{0}]}
     */
    public static Localizable _scriptNotFound(Object arg0) {
        return new Localizable(holder, "scriptNotFound", arg0);
    }

    /**
     * Key {@code skipParameter}: {@code skipping parameter [{0}] this name

     * is used internal, please rename!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code skipping parameter [{0}] this name is used internal, please

     *     rename!}
     */
    public static String skipParameter(Object arg0) {
        return holder.format("skipParameter", arg0);
    }

    /**
     * Key {@code skipParameter}: {@code skipping parameter [{0}] this name

     * is used internal, please rename!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code skipping parameter [{0}] this name is used internal, please

     *     rename!}
     */
    public static Localizable _skipParameter(Object arg0) {
        return new Localizable(holder, "skipParameter", arg0);
    }

    /**
     * Key {@code permissons_configure_description}: {@code Allow

     * configuration of Scriptler scripts, allow fine grain tuning instead of

     * giving Overall/RunScripts to everyone}.
     * 
     * @return
     *     {@code Allow configuration of Scriptler scripts, allow fine grain

     *     tuning instead of giving Overall/RunScripts to everyone}
     */
    public static String permissons_configure_description() {
        return holder.format("permissons_configure_description");
    }

    /**
     * Key {@code permissons_configure_description}: {@code Allow

     * configuration of Scriptler scripts, allow fine grain tuning instead of

     * giving Overall/RunScripts to everyone}.
     * 
     * @return
     *     {@code Allow configuration of Scriptler scripts, allow fine grain

     *     tuning instead of giving Overall/RunScripts to everyone}
     */
    public static Localizable _permissons_configure_description() {
        return new Localizable(holder, "permissons_configure_description");
    }

    /**
     * Key {@code script_loaded_from_directory}: {@code this script was

     * discovered on the file system, please describe it!}.
     * 
     * @return
     *     {@code this script was discovered on the file system, please describe

     *     it!}
     */
    public static String script_loaded_from_directory() {
        return holder.format("script_loaded_from_directory");
    }

    /**
     * Key {@code script_loaded_from_directory}: {@code this script was

     * discovered on the file system, please describe it!}.
     * 
     * @return
     *     {@code this script was discovered on the file system, please describe

     *     it!}
     */
    public static Localizable _script_loaded_from_directory() {
        return new Localizable(holder, "script_loaded_from_directory");
    }

    /**
     * Key {@code scriptdirectorytitle}: {@code The scripts are stored at:}.
     * 
     * @return
     *     {@code The scripts are stored at:}
     */
    public static String scriptdirectorytitle() {
        return holder.format("scriptdirectorytitle");
    }

    /**
     * Key {@code scriptdirectorytitle}: {@code The scripts are stored at:}.
     * 
     * @return
     *     {@code The scripts are stored at:}
     */
    public static Localizable _scriptdirectorytitle() {
        return new Localizable(holder, "scriptdirectorytitle");
    }

    /**
     * Key {@code scriptSourceNotFound}: {@code not able to load sources for

     * script [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code not able to load sources for script [{0}]}
     */
    public static String scriptSourceNotFound(Object arg0) {
        return holder.format("scriptSourceNotFound", arg0);
    }

    /**
     * Key {@code scriptSourceNotFound}: {@code not able to load sources for

     * script [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code not able to load sources for script [{0}]}
     */
    public static Localizable _scriptSourceNotFound(Object arg0) {
        return new Localizable(holder, "scriptSourceNotFound", arg0);
    }

    /**
     * Key {@code node_not_found}: {@code The node [{0}] could not be

     * found!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The node [{0}] could not be found!}
     */
    public static String node_not_found(Object arg0) {
        return holder.format("node_not_found", arg0);
    }

    /**
     * Key {@code node_not_found}: {@code The node [{0}] could not be

     * found!}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The node [{0}] could not be found!}
     */
    public static Localizable _node_not_found(Object arg0) {
        return new Localizable(holder, "node_not_found", arg0);
    }

    /**
     * Key {@code tokenmacro_ScriptDoesNotExist}: {@code No script with the

     * id [{0}] could be found.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No script with the id [{0}] could be found.}
     */
    public static String tokenmacro_ScriptDoesNotExist(Object arg0) {
        return holder.format("tokenmacro_ScriptDoesNotExist", arg0);
    }

    /**
     * Key {@code tokenmacro_ScriptDoesNotExist}: {@code No script with the

     * id [{0}] could be found.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No script with the id [{0}] could be found.}
     */
    public static Localizable _tokenmacro_ScriptDoesNotExist(Object arg0) {
        return new Localizable(holder, "tokenmacro_ScriptDoesNotExist", arg0);
    }

    /**
     * Key {@code no_parameters_defined}: {@code There is not any parameter

     * defined for this job.}.
     * 
     * @return
     *     {@code There is not any parameter defined for this job.}
     */
    public static String no_parameters_defined() {
        return holder.format("no_parameters_defined");
    }

    /**
     * Key {@code no_parameters_defined}: {@code There is not any parameter

     * defined for this job.}.
     * 
     * @return
     *     {@code There is not any parameter defined for this job.}
     */
    public static Localizable _no_parameters_defined() {
        return new Localizable(holder, "no_parameters_defined");
    }

    /**
     * Key {@code builder_name}: {@code Scriptler script}.
     * 
     * @return
     *     {@code Scriptler script}
     */
    public static String builder_name() {
        return holder.format("builder_name");
    }

    /**
     * Key {@code builder_name}: {@code Scriptler script}.
     * 
     * @return
     *     {@code Scriptler script}
     */
    public static Localizable _builder_name() {
        return new Localizable(holder, "builder_name");
    }

    /**
     * Key {@code resultPrefix}: {@code Result:  }.
     * 
     * @return
     *     {@code Result:  }
     */
    public static String resultPrefix() {
        return holder.format("resultPrefix");
    }

    /**
     * Key {@code resultPrefix}: {@code Result:  }.
     * 
     * @return
     *     {@code Result:  }
     */
    public static Localizable _resultPrefix() {
        return new Localizable(holder, "resultPrefix");
    }

    /**
     * Key {@code not_groovy_script}: {@code this is not a groovy script:

     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code this is not a groovy script: {0}}
     */
    public static String not_groovy_script(Object arg0) {
        return holder.format("not_groovy_script", arg0);
    }

    /**
     * Key {@code not_groovy_script}: {@code this is not a groovy script:

     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code this is not a groovy script: {0}}
     */
    public static Localizable _not_groovy_script(Object arg0) {
        return new Localizable(holder, "not_groovy_script", arg0);
    }

    /**
     * Key {@code display_name}: {@code Scriptler}.
     * 
     * @return
     *     {@code Scriptler}
     */
    public static String display_name() {
        return holder.format("display_name");
    }

    /**
     * Key {@code display_name}: {@code Scriptler}.
     * 
     * @return
     *     {@code Scriptler}
     */
    public static Localizable _display_name() {
        return new Localizable(holder, "display_name");
    }

    /**
     * Key {@code node_not_online}: {@code The selected node [{0}] is not

     * online, therefore the script can not be executed! Select another node

     * or start it before you try again.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The selected node [{0}] is not online, therefore the script can

     *     not be executed! Select another node or start it before you try

     *     again.}
     */
    public static String node_not_online(Object arg0) {
        return holder.format("node_not_online", arg0);
    }

    /**
     * Key {@code node_not_online}: {@code The selected node [{0}] is not

     * online, therefore the script can not be executed! Select another node

     * or start it before you try again.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The selected node [{0}] is not online, therefore the script can

     *     not be executed! Select another node or start it before you try

     *     again.}
     */
    public static Localizable _node_not_online(Object arg0) {
        return new Localizable(holder, "node_not_online", arg0);
    }

    /**
     * Key {@code agent_no_channel}: {@code No channel to the agent}.
     * 
     * @return
     *     {@code No channel to the agent}
     */
    public static String agent_no_channel() {
        return holder.format("agent_no_channel");
    }

    /**
     * Key {@code agent_no_channel}: {@code No channel to the agent}.
     * 
     * @return
     *     {@code No channel to the agent}
     */
    public static Localizable _agent_no_channel() {
        return new Localizable(holder, "agent_no_channel");
    }

    /**
     * Key {@code scriptNotApprovedYet}: {@code The script [{0}] is not yet

     * approved, consider asking your administrator to approve it.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The script [{0}] is not yet approved, consider asking your

     *     administrator to approve it.}
     */
    public static String scriptNotApprovedYet(Object arg0) {
        return holder.format("scriptNotApprovedYet", arg0);
    }

    /**
     * Key {@code scriptNotApprovedYet}: {@code The script [{0}] is not yet

     * approved, consider asking your administrator to approve it.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The script [{0}] is not yet approved, consider asking your

     *     administrator to approve it.}
     */
    public static Localizable _scriptNotApprovedYet(Object arg0) {
        return new Localizable(holder, "scriptNotApprovedYet", arg0);
    }

    /**
     * Key {@code scriptExecutionFailed}: {@code Execution of script [{0}]

     * failed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Execution of script [{0}] failed}
     */
    public static String scriptExecutionFailed(Object arg0) {
        return holder.format("scriptExecutionFailed", arg0);
    }

    /**
     * Key {@code scriptExecutionFailed}: {@code Execution of script [{0}]

     * failed}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Execution of script [{0}] failed}
     */
    public static Localizable _scriptExecutionFailed(Object arg0) {
        return new Localizable(holder, "scriptExecutionFailed", arg0);
    }

    /**
     * Key {@code uploadtext}: {@code Select a Groovy script from your local

     * system to be uploaded.}.
     * 
     * @return
     *     {@code Select a Groovy script from your local system to be uploaded.}
     */
    public static String uploadtext() {
        return holder.format("uploadtext");
    }

    /**
     * Key {@code uploadtext}: {@code Select a Groovy script from your local

     * system to be uploaded.}.
     * 
     * @return
     *     {@code Select a Groovy script from your local system to be uploaded.}
     */
    public static Localizable _uploadtext() {
        return new Localizable(holder, "uploadtext");
    }

}
