/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.git;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.RootAction;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import jenkins.model.Jenkins;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jenkinsci.main.modules.sshd.SSHD;
import org.jenkinsci.plugins.gitserver.FileBackedHttpGitRepository;
import org.jenkinsci.plugins.scriptler.ScriptlerManagement;
import org.jenkinsci.plugins.scriptler.ScriptlerPermissions;
import org.jenkinsci.plugins.scriptler.SyncUtil;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public class GitScriptlerRepository
extends FileBackedHttpGitRepository
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(GitScriptlerRepository.class.getName());
    private static final int LOG_MAX_COMMITS = 20;
    static final String REPOID = "scriptler.git";

    public GitScriptlerRepository() {
        super(ScriptlerManagement.getScriptDirectory2().toFile());
    }

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return REPOID;
    }

    public String getHttpCloneUrl() {
        return Jenkins.get().getRootUrl() + REPOID;
    }

    @Restricted(value={NoExternalUse.class})
    public int getSshdPort() {
        return SSHD.get().getActualPort();
    }

    public String getSshCloneUrl() throws MalformedURLException {
        String hostname = new URL(Objects.requireNonNull(Jenkins.get().getRootUrl())).getHost();
        int port = this.getSshdPort();
        return "ssh://" + hostname + ":" + port + "/scriptler.git";
    }

    public boolean hasPushPermission() {
        return Jenkins.get().hasPermission(ScriptlerPermissions.CONFIGURE);
    }

    public Object getScriptler() {
        return ExtensionList.lookupSingleton(ScriptlerManagement.class);
    }

    protected void checkPushPermission() {
        Jenkins.get().checkPermission(ScriptlerPermissions.CONFIGURE);
    }

    protected void updateWorkspace(Repository repo) throws IOException, GitAPIException {
        super.updateWorkspace(repo);
        ScriptlerConfiguration cfg = ((ScriptlerManagement)((Object)ExtensionList.lookupSingleton(ScriptlerManagement.class))).getConfiguration();
        SyncUtil.syncDirWithCfg(ScriptlerManagement.getScriptDirectory2(), cfg);
        cfg.save();
    }

    public void addSingleFileToRepo(String fileName) {
        try (Repository r = this.openRepository();){
            Git git = new Git(r);
            AddCommand cmd = git.add();
            cmd.addFilepattern(fileName);
            cmd.call();
            CommitCommand co = git.commit();
            co.setAuthor("Scriptler/" + Jenkins.getAuthentication2().getName(), "noreply@jenkins-ci.org");
            co.setMessage("update script via WebUI: " + fileName);
            co.call();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e, () -> "failed to add/commit " + fileName + " into Git repository");
        }
    }

    public void rmSingleFileToRepo(String fileName) {
        try (Repository r = this.openRepository();){
            Git git = new Git(r);
            RmCommand cmd = git.rm();
            cmd.addFilepattern(fileName);
            cmd.call();
            CommitCommand co = git.commit();
            co.setAuthor("Scriptler/" + Jenkins.getAuthentication2().getName(), "noreply@jenkins-ci.org");
            co.setMessage("remove script via WebUI: " + fileName);
            co.call();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e, () -> "failed to remove " + fileName + " from Git repository");
        }
    }

    public void hardReset() throws IOException {
        block9: {
            try (Repository r = this.openRepository();){
                Git git = new Git(r);
                if (!r.getRepositoryState().canResetHead()) break block9;
                try {
                    git.reset().setMode(ResetCommand.ResetType.HARD).setRef("master").call();
                }
                catch (CheckoutConflictException e) {
                    throw new IOException("not able to perform a hard reset", e);
                }
                catch (GitAPIException e) {
                    throw new IOException("problem executing reset command", e);
                }
            }
        }
    }

    public Collection<LogInfo> getLog() throws IOException {
        List<LogInfo> list;
        block9: {
            Repository r = this.openRepository();
            try {
                Iterable commits = new Git(r).log().setMaxCount(20).call();
                list = StreamSupport.stream(commits.spliterator(), false).map(LogInfo::new).toList();
                if (r == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoHeadException e) {
                    throw new IOException("not able to retrieve git log", e);
                }
                catch (GitAPIException e) {
                    throw new IOException("problem executing log command", e);
                }
            }
            r.close();
        }
        return list;
    }

    public record LogInfo(String name, PersonIdent author, PersonIdent committer, Date commitTime, String msg) {
        public LogInfo(RevCommit c) {
            this(c.getName(), c.getAuthorIdent(), c.getCommitterIdent(), new Date((long)c.getCommitTime() * 1000L), c.getFullMessage());
        }
    }
}

