/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.markup.MarkupFormatter;
import hudson.model.Computer;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ManagementLink;
import hudson.model.RootAction;
import hudson.security.Permission;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.fileupload2.core.FileItem;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.NodeNames;
import org.jenkinsci.plugins.scriptler.ScriptlerPermissions;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.git.GitScriptlerRepository;
import org.jenkinsci.plugins.scriptler.share.CatalogInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfoCatalog;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;
import org.jenkinsci.plugins.scriptler.util.UIHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class ScriptlerManagement
extends ManagementLink
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(ScriptlerManagement.class.getName());
    private static final String INVALID_PATH = "Invalid file path received: ";
    private static final String INDEX = "index";
    private static final String NOT_APPROVED_YET = "notApprovedYet";
    private static final String CAN_BYPASS_APPROVAL = "canByPassScriptApproval";
    private static final String SCRIPT = "script";

    public Permission getScriptlerRunScripts() {
        return ScriptlerPermissions.RUN_SCRIPTS;
    }

    public Permission getScriptlerConfigure() {
        return ScriptlerPermissions.CONFIGURE;
    }

    public boolean hasAtLeastOneScriptlerPermission() {
        return Jenkins.get().hasPermission(ScriptlerPermissions.RUN_SCRIPTS) || Jenkins.get().hasPermission(ScriptlerPermissions.CONFIGURE);
    }

    public void checkAtLeastOneScriptlerPermission() {
        if (!Jenkins.get().hasPermission(ScriptlerPermissions.RUN_SCRIPTS)) {
            Jenkins.get().checkPermission(ScriptlerPermissions.CONFIGURE);
        }
    }

    public String getIconFileName() {
        return this.hasAtLeastOneScriptlerPermission() ? "symbol-file-tray-stacked-outline plugin-ionicons-api" : null;
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }

    public String getUrlName() {
        return "scriptler";
    }

    public boolean disableRemoteCatalog() {
        return this.getConfiguration().isDisableRemoteCatalog();
    }

    public String getDisplayName() {
        return Messages.display_name();
    }

    public String getDescription() {
        return Messages.description();
    }

    public ScriptlerManagement getScriptler() {
        return this;
    }

    public ScriptlerConfiguration getConfiguration() {
        return ScriptlerConfiguration.getConfiguration();
    }

    public MarkupFormatter getMarkupFormatter() {
        return Jenkins.get().getMarkupFormatter();
    }

    @RequirePOST
    public HttpResponse doScriptlerSettings(StaplerRequest2 res, StaplerResponse2 rsp, @QueryParameter(value="disableRemoteCatalog") boolean disableRemoteCatalog) throws IOException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.setDisableRemoteCatalog(disableRemoteCatalog);
        cfg.save();
        return new HttpRedirect("settings");
    }

    @RequirePOST
    public HttpResponse doDownloadScript(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter(value="id") String id, @QueryParameter(value="catalog") String catalogName) throws IOException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        ScriptlerConfiguration c = this.getConfiguration();
        if (c.isDisableRemoteCatalog()) {
            return new HttpRedirect(INDEX);
        }
        for (ScriptInfoCatalog<ScriptInfo> scriptInfoCatalog : this.getCatalogs()) {
            if (!catalogName.equals(scriptInfoCatalog.getInfo().name)) continue;
            ScriptInfo info = scriptInfoCatalog.getEntryById(id);
            String source = scriptInfoCatalog.getScriptSource(scriptInfoCatalog.getEntryById(id));
            ArrayList<Parameter> paramList = new ArrayList<Parameter>();
            for (String paramName : info.getParameters()) {
                paramList.add(new Parameter(paramName, null));
            }
            String finalName = this.saveScriptAndForward(id, info.getName(), info.getComment(), source, false, false, catalogName, id, paramList);
            return new HttpRedirect("editScript?id=" + finalName);
        }
        ForwardToView view = new ForwardToView((Object)this, "catalog.jelly");
        view.with("message", (Object)Messages.download_failed(id, catalogName));
        view.with("catName", (Object)catalogName);
        return view;
    }

    @RequirePOST
    public HttpResponse doScriptAdd(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter(value="id") String id, @QueryParameter(value="name") String name, @QueryParameter(value="comment") String comment, @QueryParameter(value="script") String script, @QueryParameter(value="nonAdministerUsing") boolean nonAdministerUsing, @QueryParameter(value="onlyBuiltIn") boolean onlyBuiltIn, String originCatalogName, String originId) throws IOException, ServletException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        List<Parameter> parameters = UIHelper.extractParameters(req.getSubmittedForm());
        this.saveScriptAndForward(id, name, comment, script, nonAdministerUsing, onlyBuiltIn, originCatalogName, originId, parameters);
        return new HttpRedirect(INDEX);
    }

    private String saveScriptAndForward(String id, String name, String comment, String script, boolean nonAdministerUsing, boolean onlyBuiltIn, String originCatalogName, String originId, @NonNull List<Parameter> parameters) throws IOException {
        String string = script = script == null ? "TODO" : script;
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("'id' must not be empty!");
        }
        String displayName = name == null ? id : name;
        String finalFileName = this.fixFileName(originCatalogName, id);
        Path scriptDirectory = ScriptlerManagement.getScriptDirectory2();
        Path newScriptFile = scriptDirectory.resolve(finalFileName);
        if (!Util.isDescendant((File)scriptDirectory.toFile(), (File)newScriptFile.toFile())) {
            LOGGER.log(Level.WARNING, "Folder traversal detected, file path received: {0}, after fixing: {1}", new Object[]{id, finalFileName});
            throw new IOException(INVALID_PATH + id);
        }
        ScriptHelper.writeScriptToFile(newScriptFile, script);
        this.commitFileToGitRepo(finalFileName);
        ScriptHelper.putScriptInApprovalQueueIfRequired(script);
        Script newScript = originId != null && !originId.isEmpty() ? new Script(finalFileName, displayName, comment, true, originCatalogName, originId, new SimpleDateFormat("dd MMM yyyy HH:mm:ss").format(new Date()), parameters) : new Script(finalFileName, displayName, comment, nonAdministerUsing, parameters, onlyBuiltIn);
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.addOrReplace(newScript);
        cfg.save();
        return finalFileName;
    }

    private void commitFileToGitRepo(String finalFileName) {
        this.getGitRepo().addSingleFileToRepo(finalFileName);
    }

    @Restricted(value={NoExternalUse.class})
    public GitScriptlerRepository getGitRepo() {
        return (GitScriptlerRepository)((Object)ExtensionList.lookupSingleton(GitScriptlerRepository.class));
    }

    @RequirePOST
    public HttpResponse doHardResetGit() throws IOException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        this.getGitRepo().hardReset();
        return new HttpRedirect("../scriptler.git");
    }

    @RequirePOST
    public HttpResponse doRemoveScript(StaplerRequest2 res, StaplerResponse2 rsp, @QueryParameter(value="id") String id) throws IOException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        Path scriptDirectory = ScriptlerManagement.getScriptDirectory2();
        Path oldScript = scriptDirectory.resolve(id);
        if (!Util.isDescendant((File)scriptDirectory.toFile(), (File)oldScript.toFile())) {
            LOGGER.log(Level.WARNING, "Folder traversal detected, file path received: {0}, after fixing: {1}", new Object[]{id, oldScript});
            throw new Failure(INVALID_PATH + id);
        }
        try {
            Files.delete(oldScript);
        }
        catch (IOException e) {
            Failure failure = new Failure("not able to delete " + String.valueOf(oldScript));
            failure.initCause((Throwable)e);
            throw failure;
        }
        try {
            this.getGitRepo().rmSingleFileToRepo(id);
        }
        catch (IllegalStateException e) {
            throw new IOException("failed to update git repo", e);
        }
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.removeScript(id);
        cfg.save();
        return new HttpRedirect(INDEX);
    }

    @RequirePOST
    public HttpResponse doUploadScript(StaplerRequest2 req) throws IOException, ServletException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        try {
            FileItem fileItem = req.getFileItem2("file");
            boolean nonAdministerUsing = req.getSubmittedForm().getBoolean("nonAdministerUsing");
            String fileName = Util.getFileName((String)fileItem.getName());
            if (fileName.isEmpty()) {
                return new HttpRedirect(".");
            }
            this.saveScript(fileItem, nonAdministerUsing, fileName);
            return new HttpRedirect(INDEX);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    void saveScript(FileItem<?> fileItem, boolean nonAdministerUsing, String fileName) throws IOException {
        Path fixedFile;
        String fixedFileName = this.fixFileName(null, fileName);
        try {
            fixedFile = Paths.get(fixedFileName, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new IOException(INVALID_PATH + fileName, e);
        }
        if (fixedFile.isAbsolute()) {
            LOGGER.log(Level.WARNING, "Folder traversal detected, file path received: {0}, after fixing: {1}. Seems to be an attempt to use absolute path instead of relative one", new Object[]{fileName, fixedFileName});
            throw new IOException(INVALID_PATH + fileName);
        }
        Path rootDir = ScriptlerManagement.getScriptDirectory2();
        Path f = rootDir.resolve(fixedFileName);
        if (!Util.isDescendant((File)rootDir.toFile(), (File)f.toFile())) {
            LOGGER.log(Level.WARNING, "Folder traversal detected, file path received: {0}, after fixing: {1}. Seems to be an attempt to use folder escape.", new Object[]{fileName, fixedFileName});
            throw new IOException(INVALID_PATH + fileName);
        }
        fileItem.write(f);
        this.commitFileToGitRepo(fixedFileName);
        Script script = ScriptHelper.getScript(fixedFileName, false);
        if (script == null) {
            script = new Script(fixedFileName, fixedFileName, true, nonAdministerUsing, false);
        }
        String scriptSource = ScriptHelper.readScriptFromFile(f);
        ScriptHelper.putScriptInApprovalQueueIfRequired(scriptSource);
        ScriptlerConfiguration config = this.getConfiguration();
        config.addOrReplace(script);
    }

    public void doRunScript(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter(value="id") String id) throws IOException, ServletException {
        this.checkPermission(ScriptlerPermissions.RUN_SCRIPTS);
        Script script = ScriptHelper.getScript(id, true);
        if (script == null) {
            throw new IOException(Messages.scriptNotFound(id));
        }
        if (script.getScriptText() == null) {
            req.setAttribute("scriptNotFound", (Object)true);
        } else {
            boolean canByPassScriptApproval = Jenkins.get().hasPermission(ScriptlerPermissions.BYPASS_APPROVAL);
            if (!ScriptHelper.isApproved(script.getScriptText(), false)) {
                req.setAttribute(NOT_APPROVED_YET, (Object)true);
            }
            req.setAttribute(CAN_BYPASS_APPROVAL, (Object)canByPassScriptApproval);
        }
        req.setAttribute(SCRIPT, (Object)script);
        req.setAttribute("currentNode", (Object)"(built-in)");
        req.getView((Object)this, "runScript.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @RequirePOST
    public void doTriggerScript(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter(value="id") String id, @QueryParameter(value="script") String scriptSrc, @QueryParameter(value="node") String node) throws IOException, ServletException {
        String output;
        this.checkPermission(ScriptlerPermissions.RUN_SCRIPTS);
        List<Parameter> parameters = UIHelper.extractParameters(req.getSubmittedForm());
        boolean canByPassScriptApproval = Jenkins.get().hasPermission(ScriptlerPermissions.BYPASS_APPROVAL);
        Script originalScript = ScriptHelper.getScript(id, true);
        if (originalScript == null) {
            rsp.sendError(404, "No script found for id=" + id);
            return;
        }
        String originalScriptSourceCode = originalScript.getScriptText();
        Script tempScript = originalScript.copy();
        if (originalScriptSourceCode != null && originalScriptSourceCode.equals(scriptSrc)) {
            tempScript.setScriptText(originalScriptSourceCode);
        } else {
            tempScript.setScriptText(scriptSrc);
            ScriptHelper.putScriptInApprovalQueueIfRequired(scriptSrc);
        }
        if (ScriptHelper.isApproved(scriptSrc)) {
            List<String> computers = this.resolveComputerNames(node);
            output = ScriptHelper.runScript(computers, scriptSrc, parameters);
        } else {
            LOGGER.log(Level.WARNING, "Script {0} was not approved yet, consider asking your administrator to approve it.", id);
            output = null;
            req.setAttribute(NOT_APPROVED_YET, (Object)true);
        }
        tempScript.setParameters(parameters);
        req.setAttribute(SCRIPT, (Object)tempScript);
        req.setAttribute("currentNode", (Object)node);
        req.setAttribute("output", (Object)output);
        req.setAttribute(CAN_BYPASS_APPROVAL, (Object)canByPassScriptApproval);
        req.getView((Object)this, "runScript.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @RequirePOST
    public void doRun(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter(fixEmpty=true) String script, @QueryParameter(fixEmpty=true) String node, @QueryParameter(fixEmpty=true) String contentType) throws IOException, ServletException {
        this.checkPermission(ScriptlerPermissions.RUN_SCRIPTS);
        String id = req.getRestOfPath();
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        if (id.isEmpty()) {
            throw new IOException("Please specify a script id. Use /scriptler/run/<yourScriptId>");
        }
        Script tempScript = ScriptHelper.getScript(id, true);
        if (tempScript == null) {
            throw new IOException("Unknown script: " + id + ". Use /scriptler/run/<yourScriptId>");
        }
        if (script == null) {
            script = tempScript.getScriptText();
        }
        if (!ScriptHelper.isApproved(script)) {
            LOGGER.log(Level.WARNING, "Script {0} was not approved yet, consider asking your administrator to approve it.", id);
            rsp.sendError(403, "Script not approved yet, consider asking your administrator to approve it.");
            return;
        }
        Collection<Parameter> paramArray = this.prepareParameters(req, tempScript);
        rsp.setContentType(contentType == null ? "text/plain" : contentType);
        List<String> computers = this.resolveComputerNames(node == null ? "(built-in)" : node);
        if (computers.size() > 1) {
            rsp.getOutputStream().print(ScriptHelper.runScript(computers, script, paramArray));
        } else {
            rsp.getOutputStream().print(ScriptHelper.runScript(computers.get(0), script, paramArray));
        }
    }

    @NonNull
    private Collection<Parameter> prepareParameters(StaplerRequest2 req, Script tempScript) {
        HashMap<String, Parameter> params = new HashMap<String, Parameter>();
        for (Parameter parameter : tempScript.getParameters()) {
            params.put(parameter.getName(), parameter);
        }
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            if (!params.containsKey(entry.getKey())) continue;
            params.put((String)entry.getKey(), new Parameter((String)entry.getKey(), ((String[])entry.getValue())[0]));
        }
        return params.values();
    }

    private List<String> resolveComputerNames(String rawNameAlias) {
        List<String> computers;
        String nameAlias = NodeNames.normalizeNodeName(rawNameAlias);
        if (nameAlias.equalsIgnoreCase("(all)") || nameAlias.equalsIgnoreCase("(all agents)")) {
            computers = this.getComputerNames();
            if (nameAlias.equalsIgnoreCase("(all)")) {
                computers.add("(built-in)");
            }
        } else {
            computers = List.of(nameAlias);
        }
        return computers;
    }

    public void doShowScript(StaplerRequest2 req, StaplerResponse2 rsp, @AncestorInPath Item item, @QueryParameter(value="id") String id) throws IOException, ServletException {
        Jenkins jenkins = Jenkins.get();
        if (!jenkins.hasAnyPermission(new Permission[]{ScriptlerPermissions.RUN_SCRIPTS, ScriptlerPermissions.CONFIGURE})) {
            Jenkins parent = item == null ? jenkins : item;
            parent.checkPermission(Item.CONFIGURE);
        }
        Script script = ScriptHelper.getScript(id, true);
        req.setAttribute(SCRIPT, (Object)script);
        req.getView((Object)this, "show.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doEditScript(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter(value="id") String id) throws IOException, ServletException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        Script script = ScriptHelper.getScript(id, true);
        if (script == null || script.getScriptText() == null) {
            req.setAttribute("scriptNotFound", (Object)true);
        } else {
            boolean canByPassScriptApproval = Jenkins.get().hasPermission(ScriptlerPermissions.BYPASS_APPROVAL);
            if (!ScriptHelper.isApproved(script.getScriptText(), false)) {
                req.setAttribute(NOT_APPROVED_YET, (Object)true);
            }
            req.setAttribute(CAN_BYPASS_APPROVAL, (Object)canByPassScriptApproval);
        }
        req.setAttribute(SCRIPT, (Object)script);
        req.getView((Object)this, "edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Deprecated(since="381")
    public List<String> getSlaveAlias(Script script) {
        return this.getComputerAliases(script);
    }

    public List<String> getComputerAliases(Script script) {
        if (script.onlyBuiltIn) {
            return List.of("(built-in)");
        }
        List<String> computerNames = this.getComputerNames();
        computerNames.addAll(0, List.of("(built-in)", "(all)", "(all agents)"));
        return computerNames;
    }

    private List<String> getComputerNames() {
        return Arrays.stream(Jenkins.get().getComputers()).filter(Predicate.not(Jenkins.MasterComputer.class::isInstance)).map(Computer::getName).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<ScriptInfoCatalog<ScriptInfo>> getCatalogs() {
        return ScriptInfoCatalog.all();
    }

    public ScriptInfoCatalog<ScriptInfo> getCatalogByName(String catalogName) {
        if (catalogName != null && !catalogName.isBlank()) {
            for (ScriptInfoCatalog<ScriptInfo> sic : this.getCatalogs()) {
                CatalogInfo info = sic.getInfo();
                if (!catalogName.equals(info.name)) continue;
                return sic;
            }
        }
        return null;
    }

    public CatalogInfo getCatalogInfoByName(String catalogName) {
        if (catalogName != null && !catalogName.isBlank()) {
            for (ScriptInfoCatalog<ScriptInfo> sic : this.getCatalogs()) {
                CatalogInfo info = sic.getInfo();
                if (!catalogName.equals(info.name)) continue;
                return info;
            }
        }
        return null;
    }

    @Deprecated(since="380")
    public static File getScriptDirectory() {
        return new File(ScriptlerManagement.getScriptlerHomeDirectory(), "scripts");
    }

    public static Path getScriptDirectory2() {
        return ScriptlerManagement.getScriptlerHomeDirectory2().resolve("scripts");
    }

    @Deprecated(since="380")
    public static File getScriptlerHomeDirectory() {
        return ScriptlerManagement.getScriptlerHomeDirectory2().toFile();
    }

    public static Path getScriptlerHomeDirectory2() {
        return Jenkins.get().getRootDir().toPath().resolve("scriptler");
    }

    private void checkPermission(Permission permission) {
        Jenkins.get().checkPermission(permission);
    }

    private String fixFileName(String catalogName, String name) {
        if (!((String)name).endsWith(".groovy")) {
            if (catalogName != null && !catalogName.isEmpty()) {
                name = (String)name + "." + catalogName;
            }
            name = (String)name + ".groovy";
        }
        name = ((String)name).replace(" ", "_").trim();
        LOGGER.log(Level.FINE, "set file name to: {0}", name);
        return name;
    }
}

