/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox;

import edu.umd.cs.findbugs.annotations.CheckForNull;

public final class RejectedAccessException
extends SecurityException {
    private final String signature;
    private boolean dangerous;

    public RejectedAccessException(String type, String details) {
        super("Scripts not permitted to use " + type + " " + details);
        this.signature = type + " " + details;
    }

    public RejectedAccessException(String type, String details, String info) {
        super("Scripts not permitted to use " + type + " " + details + " (" + info + ")");
        this.signature = type + " " + details;
    }

    public RejectedAccessException(String message) {
        super(message);
        this.signature = null;
    }

    @CheckForNull
    public String getSignature() {
        return this.signature;
    }

    public boolean isDangerous() {
        return this.dangerous;
    }

    public void setDangerous(boolean dangerous) {
        if (this.signature == null && dangerous) {
            throw new IllegalArgumentException("you cannot mark this dangerous without specifying a signature");
        }
        this.dangerous = dangerous;
    }
}

