/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;

public class ProxyWhitelist
extends Whitelist {
    private volatile Whitelist[] delegates;

    public ProxyWhitelist(Collection<? extends Whitelist> delegates) {
        this.reset(delegates);
    }

    public final void reset(Collection<? extends Whitelist> delegates) {
        this.delegates = (Whitelist[])delegates.toArray(Whitelist[]::new);
    }

    public ProxyWhitelist(Whitelist ... delegates) {
        this(Arrays.asList(delegates));
    }

    protected void beforePermits() {
    }

    @Override
    public final boolean permitsMethod(@NonNull Method method, @NonNull Object receiver, @NonNull Object[] args) {
        this.beforePermits();
        for (Whitelist delegate : this.delegates) {
            if (!delegate.permitsMethod(method, receiver, args)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsConstructor(@NonNull Constructor<?> constructor, @NonNull Object[] args) {
        this.beforePermits();
        for (Whitelist delegate : this.delegates) {
            if (!delegate.permitsConstructor(constructor, args)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsStaticMethod(@NonNull Method method, @NonNull Object[] args) {
        this.beforePermits();
        for (Whitelist delegate : this.delegates) {
            if (!delegate.permitsStaticMethod(method, args)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsFieldGet(@NonNull Field field, @NonNull Object receiver) {
        this.beforePermits();
        for (Whitelist delegate : this.delegates) {
            if (!delegate.permitsFieldGet(field, receiver)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsFieldSet(@NonNull Field field, @NonNull Object receiver, Object value) {
        this.beforePermits();
        for (Whitelist delegate : this.delegates) {
            if (!delegate.permitsFieldSet(field, receiver, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsStaticFieldGet(@NonNull Field field) {
        this.beforePermits();
        for (Whitelist delegate : this.delegates) {
            if (!delegate.permitsStaticFieldGet(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean permitsStaticFieldSet(@NonNull Field field, Object value) {
        this.beforePermits();
        for (Whitelist delegate : this.delegates) {
            if (!delegate.permitsStaticFieldSet(field, value)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return super.toString() + Arrays.toString(this.delegates);
    }
}

