// CHECKSTYLE:OFF

package org.jenkinsci.plugins.scriptsecurity.scripts;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ScriptApprovalLink.dangerous}: {@code {0} approved

     * dangerous signatures}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} approved dangerous signatures}
     */
    public static String ScriptApprovalLink_dangerous(Object arg0) {
        return holder.format("ScriptApprovalLink.dangerous", arg0);
    }

    /**
     * Key {@code ScriptApprovalLink.dangerous}: {@code {0} approved

     * dangerous signatures}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} approved dangerous signatures}
     */
    public static Localizable _ScriptApprovalLink_dangerous(Object arg0) {
        return new Localizable(holder, "ScriptApprovalLink.dangerous", arg0);
    }

    /**
     * Key {@code ScriptApprovalNoteForceSandBox.message}: {@code Script

     * signature is not in the default whitelist.}.
     * 
     * @return
     *     {@code Script signature is not in the default whitelist.}
     */
    public static String ScriptApprovalNoteForceSandBox_message() {
        return holder.format("ScriptApprovalNoteForceSandBox.message");
    }

    /**
     * Key {@code ScriptApprovalNoteForceSandBox.message}: {@code Script

     * signature is not in the default whitelist.}.
     * 
     * @return
     *     {@code Script signature is not in the default whitelist.}
     */
    public static Localizable _ScriptApprovalNoteForceSandBox_message() {
        return new Localizable(holder, "ScriptApprovalNoteForceSandBox.message");
    }

    /**
     * Key {@code ClasspathEntry.path.notExists}: {@code Specified path does

     * not exist}.
     * 
     * @return
     *     {@code Specified path does not exist}
     */
    public static String ClasspathEntry_path_notExists() {
        return holder.format("ClasspathEntry.path.notExists");
    }

    /**
     * Key {@code ClasspathEntry.path.notExists}: {@code Specified path does

     * not exist}.
     * 
     * @return
     *     {@code Specified path does not exist}
     */
    public static Localizable _ClasspathEntry_path_notExists() {
        return new Localizable(holder, "ClasspathEntry.path.notExists");
    }

    /**
     * Key {@code ScriptApprovalNote.message}: {@code Administrators can

     * decide whether to approve or reject this signature.}.
     * 
     * @return
     *     {@code Administrators can decide whether to approve or reject this

     *     signature.}
     */
    public static String ScriptApprovalNote_message() {
        return holder.format("ScriptApprovalNote.message");
    }

    /**
     * Key {@code ScriptApprovalNote.message}: {@code Administrators can

     * decide whether to approve or reject this signature.}.
     * 
     * @return
     *     {@code Administrators can decide whether to approve or reject this

     *     signature.}
     */
    public static Localizable _ScriptApprovalNote_message() {
        return new Localizable(holder, "ScriptApprovalNote.message");
    }

    /**
     * Key {@code UnapprovedUsage.NonApproved}: {@code script not yet

     * approved for use}.
     * 
     * @return
     *     {@code script not yet approved for use}
     */
    public static String UnapprovedUsage_NonApproved() {
        return holder.format("UnapprovedUsage.NonApproved");
    }

    /**
     * Key {@code UnapprovedUsage.NonApproved}: {@code script not yet

     * approved for use}.
     * 
     * @return
     *     {@code script not yet approved for use}
     */
    public static Localizable _UnapprovedUsage_NonApproved() {
        return new Localizable(holder, "UnapprovedUsage.NonApproved");
    }

    /**
     * Key {@code UnapprovedUsage.ForceSandBox}: {@code Running scripts out

     * of the sandbox is not allowed in the system}.
     * 
     * @return
     *     {@code Running scripts out of the sandbox is not allowed in the

     *     system}
     */
    public static String UnapprovedUsage_ForceSandBox() {
        return holder.format("UnapprovedUsage.ForceSandBox");
    }

    /**
     * Key {@code UnapprovedUsage.ForceSandBox}: {@code Running scripts out

     * of the sandbox is not allowed in the system}.
     * 
     * @return
     *     {@code Running scripts out of the sandbox is not allowed in the

     *     system}
     */
    public static Localizable _UnapprovedUsage_ForceSandBox() {
        return new Localizable(holder, "UnapprovedUsage.ForceSandBox");
    }

    /**
     * Key {@code ScriptApproval.PipelineMessage}: {@code A Jenkins

     * administrator will need to approve this script before it can be used}.
     * 
     * @return
     *     {@code A Jenkins administrator will need to approve this script before

     *     it can be used}
     */
    public static String ScriptApproval_PipelineMessage() {
        return holder.format("ScriptApproval.PipelineMessage");
    }

    /**
     * Key {@code ScriptApproval.PipelineMessage}: {@code A Jenkins

     * administrator will need to approve this script before it can be used}.
     * 
     * @return
     *     {@code A Jenkins administrator will need to approve this script before

     *     it can be used}
     */
    public static Localizable _ScriptApproval_PipelineMessage() {
        return new Localizable(holder, "ScriptApproval.PipelineMessage");
    }

    /**
     * Key {@code ScriptApprovalLink.outstandingScript}: {@code {0} scripts

     * pending approval}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} scripts pending approval}
     */
    public static String ScriptApprovalLink_outstandingScript(Object arg0) {
        return holder.format("ScriptApprovalLink.outstandingScript", arg0);
    }

    /**
     * Key {@code ScriptApprovalLink.outstandingScript}: {@code {0} scripts

     * pending approval}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} scripts pending approval}
     */
    public static Localizable _ScriptApprovalLink_outstandingScript(Object arg0) {
        return new Localizable(holder, "ScriptApprovalLink.outstandingScript", arg0);
    }

    /**
     * Key {@code ScriptApproval.SandboxCantBeDisabled}: {@code Sandbox

     * cannot be disabled. This Jenkins instance has been configured to not

     * allow regular users to disable the sandbox in the system}.
     * 
     * @return
     *     {@code Sandbox cannot be disabled. This Jenkins instance has been

     *     configured to not allow regular users to disable the sandbox in the

     *     system}
     */
    public static String ScriptApproval_SandboxCantBeDisabled() {
        return holder.format("ScriptApproval.SandboxCantBeDisabled");
    }

    /**
     * Key {@code ScriptApproval.SandboxCantBeDisabled}: {@code Sandbox

     * cannot be disabled. This Jenkins instance has been configured to not

     * allow regular users to disable the sandbox in the system}.
     * 
     * @return
     *     {@code Sandbox cannot be disabled. This Jenkins instance has been

     *     configured to not allow regular users to disable the sandbox in the

     *     system}
     */
    public static Localizable _ScriptApproval_SandboxCantBeDisabled() {
        return new Localizable(holder, "ScriptApproval.SandboxCantBeDisabled");
    }

    /**
     * Key {@code ScriptApproval.ForceSandBoxMessage}: {@code Running scripts

     * out of the sandbox is not allowed in the system}.
     * 
     * @return
     *     {@code Running scripts out of the sandbox is not allowed in the

     *     system}
     */
    public static String ScriptApproval_ForceSandBoxMessage() {
        return holder.format("ScriptApproval.ForceSandBoxMessage");
    }

    /**
     * Key {@code ScriptApproval.ForceSandBoxMessage}: {@code Running scripts

     * out of the sandbox is not allowed in the system}.
     * 
     * @return
     *     {@code Running scripts out of the sandbox is not allowed in the

     *     system}
     */
    public static Localizable _ScriptApproval_ForceSandBoxMessage() {
        return new Localizable(holder, "ScriptApproval.ForceSandBoxMessage");
    }

    /**
     * Key {@code ClasspathEntry.path.noDirsAllowed}: {@code Class

     * directories are not allowed as classpath entries.}.
     * 
     * @return
     *     {@code Class directories are not allowed as classpath entries.}
     */
    public static String ClasspathEntry_path_noDirsAllowed() {
        return holder.format("ClasspathEntry.path.noDirsAllowed");
    }

    /**
     * Key {@code ClasspathEntry.path.noDirsAllowed}: {@code Class

     * directories are not allowed as classpath entries.}.
     * 
     * @return
     *     {@code Class directories are not allowed as classpath entries.}
     */
    public static Localizable _ClasspathEntry_path_noDirsAllowed() {
        return new Localizable(holder, "ClasspathEntry.path.noDirsAllowed");
    }

    /**
     * Key {@code ScriptApprovalLink.outstandingSignature}: {@code {0}

     * signatures pending approval}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} signatures pending approval}
     */
    public static String ScriptApprovalLink_outstandingSignature(Object arg0) {
        return holder.format("ScriptApprovalLink.outstandingSignature", arg0);
    }

    /**
     * Key {@code ScriptApprovalLink.outstandingSignature}: {@code {0}

     * signatures pending approval}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} signatures pending approval}
     */
    public static Localizable _ScriptApprovalLink_outstandingSignature(Object arg0) {
        return new Localizable(holder, "ScriptApprovalLink.outstandingSignature", arg0);
    }

    /**
     * Key {@code ClasspathEntry.path.notApproved}: {@code This classpath

     * entry is not approved. Require an approval before execution.}.
     * 
     * @return
     *     {@code This classpath entry is not approved. Require an approval

     *     before execution.}
     */
    public static String ClasspathEntry_path_notApproved() {
        return holder.format("ClasspathEntry.path.notApproved");
    }

    /**
     * Key {@code ClasspathEntry.path.notApproved}: {@code This classpath

     * entry is not approved. Require an approval before execution.}.
     * 
     * @return
     *     {@code This classpath entry is not approved. Require an approval

     *     before execution.}
     */
    public static Localizable _ClasspathEntry_path_notApproved() {
        return new Localizable(holder, "ClasspathEntry.path.notApproved");
    }

    /**
     * Key {@code ScriptApproval.AdminUserAlert}: {@code <b>Sandbox is

     * enabled globally in the system.</b><br />}.
     * 
     * @return
     *     {@code <b>Sandbox is enabled globally in the system.</b><br />}
     */
    public static String ScriptApproval_AdminUserAlert() {
        return holder.format("ScriptApproval.AdminUserAlert");
    }

    /**
     * Key {@code ScriptApproval.AdminUserAlert}: {@code <b>Sandbox is

     * enabled globally in the system.</b><br />}.
     * 
     * @return
     *     {@code <b>Sandbox is enabled globally in the system.</b><br />}
     */
    public static Localizable _ScriptApproval_AdminUserAlert() {
        return new Localizable(holder, "ScriptApproval.AdminUserAlert");
    }

    /**
     * Key {@code ScriptApprovalLink.outstandingClasspath}: {@code {0}

     * classpath entries pending approval}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} classpath entries pending approval}
     */
    public static String ScriptApprovalLink_outstandingClasspath(Object arg0) {
        return holder.format("ScriptApprovalLink.outstandingClasspath", arg0);
    }

    /**
     * Key {@code ScriptApprovalLink.outstandingClasspath}: {@code {0}

     * classpath entries pending approval}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} classpath entries pending approval}
     */
    public static Localizable _ScriptApprovalLink_outstandingClasspath(Object arg0) {
        return new Localizable(holder, "ScriptApprovalLink.outstandingClasspath", arg0);
    }

}
