// CHECKSTYLE:OFF

package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code GroovySandbox.useOfInsecureRunOverload}: {@code

     * GroovySandbox.run(Script, Whitelist) is insecure and deprecated.

     * GroovySandbox.run(GroovyShell, String, Whitelist) should be used

     * instead.}.
     * 
     * @return
     *     {@code GroovySandbox.run(Script, Whitelist) is insecure and

     *     deprecated. GroovySandbox.run(GroovyShell, String, Whitelist) should

     *     be used instead.}
     */
    public static String GroovySandbox_useOfInsecureRunOverload() {
        return holder.format("GroovySandbox.useOfInsecureRunOverload");
    }

    /**
     * Key {@code GroovySandbox.useOfInsecureRunOverload}: {@code

     * GroovySandbox.run(Script, Whitelist) is insecure and deprecated.

     * GroovySandbox.run(GroovyShell, String, Whitelist) should be used

     * instead.}.
     * 
     * @return
     *     {@code GroovySandbox.run(Script, Whitelist) is insecure and

     *     deprecated. GroovySandbox.run(GroovyShell, String, Whitelist) should

     *     be used instead.}
     */
    public static Localizable _GroovySandbox_useOfInsecureRunOverload() {
        return new Localizable(holder, "GroovySandbox.useOfInsecureRunOverload");
    }

}
