/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl;

import hudson.scm.NullSCM;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.impl.NullSCMSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

@WithJenkins
class NullSCMSourceTest {
    NullSCMSourceTest() {
    }

    @Test
    void given_instance_when_fetch_then_noRevisionObserved(JenkinsRule r) throws Exception {
        SCMHeadObserver observer = (SCMHeadObserver)Mockito.mock(SCMHeadObserver.class);
        NullSCMSource instance = new NullSCMSource();
        instance.fetch(null, observer, null);
        ((SCMHeadObserver)Mockito.verify((Object)observer, (VerificationMode)Mockito.never())).observe((SCMHead)MockitoHamcrest.argThat((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(SCMHead.class), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"the-name")))), (SCMRevision)MockitoHamcrest.argThat((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(SCMRevision.class), (Matcher)Matchers.hasProperty((String)"head", (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"the-name"))), (Matcher)Matchers.hasProperty((String)"deterministic", (Matcher)Matchers.is((Object)false)))));
    }

    @Test
    void given_instance_when_fetchingNonObservedHead_then_nullScmReturned(JenkinsRule r) {
        NullSCMSource instance = new NullSCMSource();
        MatcherAssert.assertThat((Object)instance.build(new SCMHead("foo"), (SCMRevision)Mockito.mock(SCMRevision.class)), (Matcher)Matchers.instanceOf(NullSCM.class));
    }
}

