/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.avatars;

import hudson.ExtensionList;
import hudson.model.UnprotectedRootAction;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import jenkins.scm.impl.avatars.AvatarCache;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;
import org.kohsuke.stapler.HttpResponse;

public class AvatarCacheTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fakeUrl() throws Exception {
        String lastModified;
        CountDownLatch requestsPending = new CountDownLatch(5);
        CountDownLatch blockReady = new CountDownLatch(4);
        for (Callable<Void> callable : this.fakeWork(requestsPending, blockReady)) {
            this.worker().submit(callable);
        }
        blockReady.await(10L, TimeUnit.SECONDS);
        String url = this.callBuildUrl("about:blank", "32x32");
        MatcherAssert.assertThat((Object)url, (Matcher)Matchers.is((Object)(r.getURL().toString() + "avatar-cache/0ffc09cf03c14f063afa7f03a5f4b074.png?size=32x32")));
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(url).openConnection();
        try {
            httpURLConnection.connect();
            MatcherAssert.assertThat((Object)httpURLConnection.getResponseCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)httpURLConnection.getLastModified(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
            MatcherAssert.assertThat((Object)httpURLConnection.getHeaderField("Cache-Control"), (Matcher)Matchers.is((Object)"max-age=365000000, immutable, public"));
        }
        finally {
            httpURLConnection.disconnect();
        }
        requestsPending.countDown();
        CountDownLatch requestsComplete = new CountDownLatch(4);
        this.worker().invokeAll(this.fakeWork(requestsComplete, blockReady));
        HttpURLConnection httpURLConnection2 = (HttpURLConnection)new URL(url).openConnection();
        try {
            httpURLConnection2.connect();
            MatcherAssert.assertThat((Object)httpURLConnection2.getResponseCode(), (Matcher)Matchers.is((Object)200));
            lastModified = httpURLConnection2.getHeaderField("Last-Modified");
            MatcherAssert.assertThat((Object)httpURLConnection2.getLastModified(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
            MatcherAssert.assertThat((Object)httpURLConnection2.getHeaderField("Cache-Control"), (Matcher)Matchers.is((Object)"max-age=365000000, immutable, public"));
        }
        finally {
            httpURLConnection2.disconnect();
        }
        HttpURLConnection httpURLConnection3 = (HttpURLConnection)new URL(url).openConnection();
        try {
            httpURLConnection3.setRequestProperty("If-Modified-Since", lastModified);
            httpURLConnection3.connect();
            MatcherAssert.assertThat((Object)httpURLConnection3.getResponseCode(), (Matcher)Matchers.is((Object)304));
            MatcherAssert.assertThat((Object)httpURLConnection3.getLastModified(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
            MatcherAssert.assertThat((Object)httpURLConnection3.getHeaderField("Cache-Control"), (Matcher)Matchers.is((Object)"max-age=365000000, immutable, public"));
        }
        finally {
            httpURLConnection3.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void realUrl() throws Exception {
        String lastModified;
        CountDownLatch requestsPending = new CountDownLatch(5);
        CountDownLatch blockReady = new CountDownLatch(4);
        for (Callable<Void> callable : this.fakeWork(requestsPending, blockReady)) {
            this.worker().submit(callable);
        }
        blockReady.await(10L, TimeUnit.SECONDS);
        String url = this.callBuildUrl(r.getURL().toString() + "plugin/scm-api/test-avatar.png", "32x32");
        MatcherAssert.assertThat((Object)url, (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)(r.getURL().toString() + "avatar-cache/")), (Matcher)Matchers.endsWith((String)".png?size=32x32")));
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(url).openConnection();
        try {
            httpURLConnection.connect();
            MatcherAssert.assertThat((Object)httpURLConnection.getResponseCode(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)httpURLConnection.getLastModified(), (Matcher)Matchers.is((Object)0L));
            MatcherAssert.assertThat((Object)httpURLConnection.getHeaderField("Cache-Control"), (Matcher)Matchers.is((Object)"no-cache, public"));
        }
        finally {
            httpURLConnection.disconnect();
        }
        requestsPending.countDown();
        CountDownLatch requestsComplete = new CountDownLatch(4);
        this.worker().invokeAll(this.fakeWork(requestsComplete, blockReady));
        HttpURLConnection httpURLConnection2 = (HttpURLConnection)new URL(url).openConnection();
        try {
            httpURLConnection2.connect();
            MatcherAssert.assertThat((Object)httpURLConnection2.getResponseCode(), (Matcher)Matchers.is((Object)200));
            lastModified = httpURLConnection2.getHeaderField("Last-Modified");
            MatcherAssert.assertThat((Object)httpURLConnection2.getLastModified(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
            MatcherAssert.assertThat((Object)httpURLConnection2.getHeaderField("Cache-Control"), (Matcher)Matchers.is((Object)"max-age=3600, public"));
        }
        finally {
            httpURLConnection2.disconnect();
        }
        System.out.println(lastModified);
        HttpURLConnection httpURLConnection3 = (HttpURLConnection)new URL(url).openConnection();
        try {
            httpURLConnection3.setRequestProperty("If-Modified-Since", lastModified);
            httpURLConnection3.connect();
            MatcherAssert.assertThat((Object)httpURLConnection3.getResponseCode(), (Matcher)Matchers.is((Object)304));
            MatcherAssert.assertThat((Object)httpURLConnection3.getLastModified(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
            MatcherAssert.assertThat((Object)httpURLConnection3.getHeaderField("Cache-Control"), (Matcher)Matchers.is((Object)"max-age=3600, public"));
        }
        finally {
            httpURLConnection3.disconnect();
        }
    }

    private ExecutorService worker() {
        return ((AvatarCache)ExtensionList.lookup(UnprotectedRootAction.class).get(AvatarCache.class)).service;
    }

    private List<Callable<Void>> fakeWork(final CountDownLatch latch, final CountDownLatch running) {
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        for (int i = 0; i < 4; ++i) {
            tasks.add(new Callable<Void>(this){
                final /* synthetic */ AvatarCacheTest this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Void call() throws Exception {
                    running.countDown();
                    latch.countDown();
                    latch.await(10L, TimeUnit.SECONDS);
                    return null;
                }
            });
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String callBuildUrl(String url, String size) throws IOException {
        ProbeAction a = (ProbeAction)ExtensionList.lookup(UnprotectedRootAction.class).get(ProbeAction.class);
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.notNullValue());
        ProbeAction probeAction = a;
        synchronized (probeAction) {
            String string;
            a.url = url;
            a.size = size;
            HttpURLConnection c = (HttpURLConnection)new URL(r.getURL().toString() + a.getUrlName() + "/").openConnection();
            try {
                c.connect();
                string = IOUtils.toString((InputStream)c.getInputStream(), (Charset)StandardCharsets.UTF_8).trim();
                c.disconnect();
            }
            catch (Throwable throwable) {
                c.disconnect();
                throw throwable;
            }
            return string;
        }
    }

    @TestExtension
    public static class ProbeAction
    implements UnprotectedRootAction {
        private String url;
        private String size;

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return "probe-action";
        }

        public HttpResponse doIndex() {
            return HttpResponses.text((String)AvatarCache.buildUrl((String)this.url, (String)this.size));
        }
    }
}

