/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import jenkins.scm.impl.mock.AbstractSampleRepoRule;
import org.apache.commons.io.FileUtils;

public abstract class AbstractSampleDVCSRepoRule
extends AbstractSampleRepoRule {
    protected File sampleRepo;

    @Override
    protected void before() throws Throwable {
        super.before();
        this.sampleRepo = this.tmp.newFolder();
    }

    public final void write(String rel, String text) throws IOException {
        FileUtils.write((File)new File(this.sampleRepo, rel), (CharSequence)text, (Charset)StandardCharsets.UTF_8);
    }

    public final String toString() {
        return this.sampleRepo.getAbsolutePath();
    }

    public abstract void init() throws Exception;

    protected final void run(String tool, String ... cmds) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add(tool);
        args.addAll(Arrays.asList(cmds));
        AbstractSampleDVCSRepoRule.run(false, this.sampleRepo, args.toArray(new String[0]));
    }

    public final String bareUrl() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.toString(), StandardCharsets.UTF_8);
    }

    public final String fileUrl() {
        return this.sampleRepo.toURI().toString();
    }
}

