/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import hudson.model.Action;
import hudson.model.Actionable;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMDiscoverBranches;
import jenkins.scm.impl.mock.MockSCMHead;
import jenkins.scm.impl.mock.MockSCMRevision;
import jenkins.scm.impl.mock.MockSCMSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SCMRevisionActionTest {
    @Test
    public void given__legacyData__when__gettingRevision__then__legacyReturned() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            MockSCMSource source = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            MockSCMRevision revision = new MockSCMRevision(new MockSCMHead("head"), "hash");
            ActionableImpl a = new ActionableImpl();
            a.addAction((Action)new SCMRevisionAction((SCMRevision)revision, null));
            MatcherAssert.assertThat((Object)SCMRevisionAction.getRevision((SCMSource)source, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision)));
        }
    }

    @Test
    public void given__mixedData__when__gettingRevision__then__legacyReturnedForUnmatched() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            MockSCMSource source1 = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            source1.setId("foo");
            MockSCMSource source2 = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            source2.setId("bar");
            MockSCMSource source3 = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            source3.setId("manchu");
            MockSCMRevision revision1 = new MockSCMRevision(new MockSCMHead("head1"), "hash1");
            MockSCMRevision revision2 = new MockSCMRevision(new MockSCMHead("head2"), "hash2");
            MockSCMRevision revision3 = new MockSCMRevision(new MockSCMHead("head3"), "hash3");
            ActionableImpl a = new ActionableImpl();
            a.addAction((Action)new SCMRevisionAction((SCMSource)source1, (SCMRevision)revision1));
            a.addAction((Action)new SCMRevisionAction((SCMRevision)revision2, null));
            a.addAction((Action)new SCMRevisionAction((SCMSource)source3, (SCMRevision)revision3));
            MatcherAssert.assertThat((Object)SCMRevisionAction.getRevision((SCMSource)source1, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision1)));
            MatcherAssert.assertThat((Object)SCMRevisionAction.getRevision((SCMSource)source2, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision2)));
            MatcherAssert.assertThat((Object)SCMRevisionAction.getRevision((SCMSource)source3, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision3)));
        }
    }

    @Test
    public void given__mixedData__when__gettingRevision__then__firstlegacyReturnedForUnmatched() throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            MockSCMSource source1 = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            source1.setId("foo");
            MockSCMSource source2 = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            source2.setId("bar");
            MockSCMSource source3 = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            source3.setId("manchu");
            MockSCMRevision revision1 = new MockSCMRevision(new MockSCMHead("head1"), "hash1");
            MockSCMRevision revision2 = new MockSCMRevision(new MockSCMHead("head2"), "hash2");
            MockSCMRevision revision3 = new MockSCMRevision(new MockSCMHead("head3"), "hash3");
            ActionableImpl a = new ActionableImpl();
            a.addAction((Action)new SCMRevisionAction((SCMSource)source1, (SCMRevision)revision1));
            a.addAction((Action)new SCMRevisionAction((SCMRevision)revision2, null));
            a.addAction((Action)new SCMRevisionAction((SCMRevision)revision3, null));
            MatcherAssert.assertThat((Object)SCMRevisionAction.getRevision((SCMSource)source1, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision1)));
            MatcherAssert.assertThat((Object)SCMRevisionAction.getRevision((SCMSource)source2, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision2)));
            MatcherAssert.assertThat((String)"Cannot distinguish legacy", (Object)SCMRevisionAction.getRevision((SCMSource)source3, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision2)));
        }
    }

    private static class ActionableImpl
    extends Actionable {
        private ActionableImpl() {
        }

        public String getDisplayName() {
            return null;
        }

        public String getSearchUrl() {
            return null;
        }

        public <T extends Action> List<T> getActions(Class<T> type) {
            return this.getActions().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
        }
    }
}

