/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMNavigatorEvent;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.trait.SCMNavigatorRequest;
import jenkins.scm.api.trait.SCMNavigatorTrait;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.api.trait.SCMTraitDescriptor;
import jenkins.scm.impl.mock.MockAvatarMetadataAction;
import jenkins.scm.impl.mock.MockSCMBuilder;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMDiscoverBranches;
import jenkins.scm.impl.mock.MockSCMLink;
import jenkins.scm.impl.mock.MockSCMNavigatorContext;
import jenkins.scm.impl.mock.MockSCMNavigatorRequest;
import jenkins.scm.impl.mock.MockSCMSourceBuilder;
import jenkins.scm.impl.mock.MockSCMSourceContext;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class MockSCMNavigator
extends SCMNavigator {
    private final String controllerId;
    private final List<SCMTrait<?>> traits;
    private transient MockSCMController controller;

    @DataBoundConstructor
    public MockSCMNavigator(String controllerId, List<SCMTrait<?>> traits) {
        this.controllerId = controllerId;
        this.traits = SCMTrait.asSetList(traits);
    }

    public MockSCMNavigator(String controllerId, SCMTrait<?> ... traits) {
        this(controllerId, Arrays.asList(traits));
    }

    public MockSCMNavigator(MockSCMController controller, List<SCMTrait<?>> traits) {
        this.controllerId = controller.getId();
        this.controller = controller;
        this.traits = SCMTrait.asSetList(traits);
    }

    public MockSCMNavigator(MockSCMController controller, SCMTrait<?> ... traits) {
        this(controller, Arrays.asList(traits));
    }

    public String getControllerId() {
        return this.controllerId;
    }

    private MockSCMController controller() {
        if (this.controller == null) {
            this.controller = MockSCMController.lookup(this.controllerId);
        }
        return this.controller;
    }

    @NonNull
    public List<SCMTrait<?>> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    public void setTraits(@CheckForNull List<SCMTrait<?>> traits) {
        this.traits.clear();
        this.traits.addAll(SCMTrait.asSetList(traits));
    }

    @NonNull
    protected String id() {
        return this.controllerId;
    }

    public void visitSources(@NonNull SCMSourceObserver observer) throws IOException, InterruptedException {
        try (final MockSCMNavigatorRequest request = ((MockSCMNavigatorContext)new MockSCMNavigatorContext().withTraits(this.traits)).newRequest(this, observer);){
            this.controller().applyLatency();
            this.controller().checkFaults(null, null, null, false);
            for (String name : this.controller().listRepositories()) {
                if (request.isExcluded(name)) continue;
                this.controller().applyLatency();
                this.controller().checkFaults(name, null, null, false);
                if (!request.process(name, new SCMNavigatorRequest.SourceLambda(){
                    final /* synthetic */ MockSCMNavigator this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @NonNull
                    public SCMSource create(@NonNull String name) {
                        return ((MockSCMSourceBuilder)new MockSCMSourceBuilder(this.this$0.controller, name).withId(this.this$0.getId() + "::" + name).withRequest(request)).build();
                    }
                }, null, new SCMNavigatorRequest.Witness[0])) continue;
                return;
            }
        }
    }

    @NonNull
    public List<Action> retrieveActions(@NonNull SCMNavigatorOwner owner, @CheckForNull SCMNavigatorEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        this.controller().applyLatency();
        this.controller().checkFaults(null, null, null, true);
        ArrayList<Action> result = new ArrayList<Action>();
        result.add(new MockSCMLink("organization"));
        String description = this.controller().getDescription();
        String displayName = this.controller().getDisplayName();
        String url = this.controller().getUrl();
        String iconClassName = this.controller().getOrgIconClassName();
        if (description != null || displayName != null || url != null) {
            result.add((Action)new ObjectMetadataAction(displayName, description, url));
        }
        if (iconClassName != null) {
            result.add((Action)new MockAvatarMetadataAction(iconClassName));
        }
        return result;
    }

    public void afterSave(@NonNull SCMNavigatorOwner owner) {
        this.controller().afterSave(this, owner);
    }

    @Symbol(value={"mockScm"})
    @Extension
    public static class DescriptorImpl
    extends SCMNavigatorDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Mock SCM";
        }

        public SCMNavigator newInstance(@CheckForNull String name) {
            return null;
        }

        public ListBoxModel doFillControllerIdItems() {
            ListBoxModel result = new ListBoxModel();
            for (MockSCMController c : MockSCMController.all()) {
                result.add(c.getId());
            }
            return result;
        }

        public List<SCMTraitDescriptor<?>> getTraitsDescriptors() {
            ArrayList descriptors = new ArrayList();
            descriptors.addAll(SCMNavigatorTrait._for(MockSCMNavigatorContext.class, MockSCMSourceBuilder.class));
            descriptors.addAll(SCMSourceTrait._for(MockSCMSourceContext.class, MockSCMBuilder.class));
            return descriptors;
        }

        @NonNull
        public List<SCMTrait<?>> getTraitsDefaults() {
            return Collections.singletonList(new MockSCMDiscoverBranches());
        }
    }
}

