/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.trait;

import java.util.Map;
import java.util.TreeSet;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.impl.mock.MockRepositoryFlags;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMDiscoverBranches;
import jenkins.scm.impl.mock.MockSCMSource;
import jenkins.scm.impl.trait.RegexSCMHeadFilterTrait;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class RegexSCMHeadFilterTraitTest {
    RegexSCMHeadFilterTraitTest() {
    }

    @Test
    void given_sourceWithRegexRule_when_scanning_then_ruleApplied(JenkinsRule r) throws Exception {
        try (MockSCMController c = MockSCMController.create();){
            c.createRepository("foo", new MockRepositoryFlags[0]);
            c.createBranch("foo", "fork");
            c.createBranch("foo", "alt");
            MockSCMSource src = new MockSCMSource(c, "foo", new SCMSourceTrait[]{new MockSCMDiscoverBranches(), new RegexSCMHeadFilterTrait("[fm].*")});
            Map result = ((SCMHeadObserver.Collector)src.fetch(null, (SCMHeadObserver)SCMHeadObserver.collect(), null, null)).result();
            TreeSet<String> names = new TreeSet<String>();
            for (SCMHead h : result.keySet()) {
                names.add(h.getName());
            }
            MatcherAssert.assertThat(names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"master", "fork"}));
        }
    }
}

