/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import java.io.IOException;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.impl.mock.MockSCM;
import jenkins.scm.impl.mock.MockSCMSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class SCMFileSystemTest {
    SCMFileSystemTest() {
    }

    @Test
    void filesystem_supports_false_by_default_for_descriptor(JenkinsRule r) {
        SCMSourceDescriptor descriptor = (SCMSourceDescriptor)r.jenkins.getDescriptorByType(MockSCMSource.DescriptorImpl.class);
        Assertions.assertFalse((boolean)SCMFileSystem.supports((SCMSourceDescriptor)descriptor));
        SCMDescriptor scmDescriptor = (SCMDescriptor)r.jenkins.getDescriptorByType(MockSCM.DescriptorImpl.class);
        Assertions.assertFalse((boolean)SCMFileSystem.supports((SCMDescriptor)scmDescriptor));
    }

    @Test
    void filesystem_supports_true_implementation_for_descriptor(JenkinsRule r) {
        SCMSourceDescriptor descriptor = (SCMSourceDescriptor)r.jenkins.getDescriptorByType(MockSCMSource.DescriptorImpl.class);
        Assertions.assertTrue((boolean)SCMFileSystem.supports((SCMSourceDescriptor)descriptor));
        SCMDescriptor scmDescriptor = (SCMDescriptor)r.jenkins.getDescriptorByType(MockSCM.DescriptorImpl.class);
        Assertions.assertTrue((boolean)SCMFileSystem.supports((SCMDescriptor)scmDescriptor));
    }

    @Test
    void filesystem_supports_false_implementation_for_descriptor(JenkinsRule r) {
        SCMSourceDescriptor descriptor = (SCMSourceDescriptor)r.jenkins.getDescriptorByType(MockSCMSource.DescriptorImpl.class);
        Assertions.assertFalse((boolean)SCMFileSystem.supports((SCMSourceDescriptor)descriptor));
        SCMDescriptor scmDescriptor = (SCMDescriptor)r.jenkins.getDescriptorByType(MockSCM.DescriptorImpl.class);
        Assertions.assertFalse((boolean)SCMFileSystem.supports((SCMDescriptor)scmDescriptor));
    }

    @TestExtension(value={"filesystem_supports_false_implementation_for_descriptor"})
    public static class FalseBuilder
    extends SCMFileSystem.Builder {
        public boolean supports(SCM source) {
            return !(source instanceof MockSCM);
        }

        public boolean supports(SCMSource source) {
            return !(source instanceof MockSCMSource);
        }

        protected boolean supportsDescriptor(SCMDescriptor descriptor) {
            return !(descriptor instanceof MockSCM.DescriptorImpl);
        }

        protected boolean supportsDescriptor(SCMSourceDescriptor descriptor) {
            return !(descriptor instanceof MockSCMSource.DescriptorImpl);
        }

        @CheckForNull
        public SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
            return null;
        }
    }

    @TestExtension(value={"filesystem_supports_true_implementation_for_descriptor"})
    public static class TrueBuilder
    extends SCMFileSystem.Builder {
        public boolean supports(SCM source) {
            return source instanceof MockSCM;
        }

        public boolean supports(SCMSource source) {
            return source instanceof MockSCMSource;
        }

        protected boolean supportsDescriptor(SCMDescriptor descriptor) {
            System.err.println("SUP: " + String.valueOf(descriptor));
            return descriptor instanceof MockSCM.DescriptorImpl;
        }

        protected boolean supportsDescriptor(SCMSourceDescriptor descriptor) {
            System.err.println("SRC SUP: " + String.valueOf(descriptor));
            return descriptor instanceof MockSCMSource.DescriptorImpl;
        }

        @CheckForNull
        public SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
            return null;
        }
    }
}

